// --------------------------------------------------------
//  mGTFTini.h (c) CopYright 2013-2014 Goji.
// --------------------------------------------------------

DigitalOut TFT_RD(TFT_pin_RD);
DigitalOut TFT_WR(TFT_pin_WR);
DigitalOut TFT_CS(TFT_pin_CS);
DigitalOut TFT_RS(TFT_pin_RS);
DigitalOut TFT_RESET(TFT_pin_RESET);

#define TFT_RESET_0     TFT_RESET = 0
#define TFT_RESET_1     TFT_RESET = 1
#define TFT_RS_0        TFT_RS = 0
#define TFT_RS_1        TFT_RS = 1
#define TFT_WR_0        TFT_WR = 0
#define TFT_WR_1        TFT_WR = 1
#define TFT_CS_0        TFT_CS = 0
#define TFT_CS_1        TFT_CS = 1
#define TFT_RD_0        TFT_RD = 0
#define TFT_RD_1        TFT_RD = 1

TFT_INFO TFT_info = {
    TFT_MIN_X,
    TFT_MAX_X,
    TFT_MIN_Y,
    TFT_MAX_Y,
    TPC_XNON,
    TPC_XMIN,
    TPC_XMAX,
    TPC_YNON,
    TPC_YMIN,
    TPC_YMAX
};


//---------------------------------------------------------------------
#if defined(ILI9325)
//---------------------------------------------------------------------
uint16_t TFT_Init_table[] = {
    // http://www.ilitek.com ILI9325 Application Notes
    // - Set internal timing ------------ //
    0xE3, 0x3008,    // Set internal timing
    0xE7, 0x0012,
    0xEF, 0x1231,

    // - Start Initial Sequence --------- //
    0x01, 0x0100,    // set SS and SM bit
    0x02, 0x0700,    // set 1 line inversion
    0x03, 0x1038,    // set GRAM write direction and BGR=1.
    0x04, 0x0000,    // Resize register
    0x08, 0x0207,    // set the back porch and front porch
    0x09, 0x0000,    // set non-display area refresh cycle ISC[3:0]
    0x0A, 0x0000,    // FMARK function
    0x0C, 0x0000,    // RGB interface setting
    0x0D, 0x0000,    // Frame marker Position
    0x0F, 0x0000,    // RGB interface polarity

    // - Power On sequence -------------- //
    0x10, 0x0000,    // SAP, BT[3:0], AP, DSTB, SLP, STB
    0x11, 0x0007,    // DC1[2:0], DC0[2:0], VC[2:0]
    0x12, 0x0000,    // VREG1OUT voltage
    0x13, 0x0000,    // VDV[4:0] for VCOM amplitude
      WW,    200,

    0x10, 0x1490,    // SAP, BT[3:0], AP, DSTB, SLP, STB
    0x11, 0x0227,    // DC1[2:0], DC0[2:0], VC[2:0]
      WW,     50,

    0x12, 0x001C,    // External reference voltage Vci, Vci x 1.80
    0x07, 0x0001,
      WW,     50,

    0x13, 0x1A00,    // Power Control 4: VREG1OUT x 1.14
    0x29, 0x0025,    // Power Control 7: VREG1OUT x 0.870
    0x2B, 0x000D,    // Frame Rate Control: 8 fps
      WW,     50,

    0x20, 0x0000,
    0x21, 0x013F,

    // - Adjust the Gamma Curve --------- //
    0x30, 0x0000,
    0x31, 0x0506,
    0x32, 0x0104,
    0x35, 0x0207,
    0x36, 0x000F,
    0x37, 0x0306,
    0x38, 0x0102,
    0x39, 0x0707,
    0x3C, 0x0702,
    0x3D, 0x1604,

    // - Set GRAM area ------------------ //
    0x50, 0x0000,           // Horizontal GRAM Start Address
    0x51, TFT_MAX_Y - 1,    // Horizontal GRAM End Address
    0x52, 0x0000,           // Vertical GRAM Start Address
    0x53, TFT_MAX_X - 1,    // Vertical GRAM Start Address

    0x60, 0xA700,           // Gate Scan Line
    0x61, 0x0001,           // NDL,VLE, REV
    0x6A, 0x0000,           // set scrolling line

    // - Partial Display Control ---------//
    0x80, 0x0000,
    0x81, 0x0000,
    0x82, 0x0000,
    0x83, 0x0000,
    0x84, 0x0000,
    0x85, 0x0000,

    // - Panel Control -------------------//
    0x90, 0x0010,
    0x92, 0x0600,
    0x93, 0x0003,
    0x95, 0x0110,
    0x97, 0x0000,
    0x98, 0x0000,

    // - 262K ccode and display ON ------ //
    0x07, 0x0133,
      WW,      0
};

//---------------------------------------------------------------------
#elif defined(ST7783)
//---------------------------------------------------------------------
uint16_t TFT_Init_table[] = {
    0x01, 0x0100,
    0x02, 0x0700,
    0x03, 0x1038,
    0x04, 0x0000,

    0x08, 0x0302,
    0x09, 0x0008,
    0x0A, 0x0008,

    0x10, 0x0790,
    0x11, 0x0005,
    0x12, 0x0000,
    0x13, 0x0000,
      WW,    100,

    0x10, 0x12B0,
    0x11, 0x0007,
      WW,    100,

    0x12, 0x008C,
    0x13, 0x1700,
      WW,    100,

    0x29, 0x0222,
      WW,    100,

    0x30, 0x0000,
    0x31, 0x0405,
    0x32, 0x0203,
    0x35, 0x0004,
    0x36, 0x0B07,
    0x37, 0x0000,
    0x38, 0x0405,
    0x39, 0x0203,
    0x3C, 0x0004,
    0x3D, 0x0B07,

    0x50, 0x0000,           // Horizontal GRAM Start Address
    0x51, TFT_MAX_Y - 1,    // Horizontal GRAM End Address
    0x52, 0x0000,           // Vertical GRAM Start Address
    0x53, TFT_MAX_X - 1,    // Vertical GRAM Start Address

    0x60, 0x2700,
    0x61, 0x0001,
    0x6A, 0x0033,
    0x90, 0x0033,
    0x07, 0x0133,
      WW,      0
};

#else
  #error "TFT Hardware not defined."
#endif


#define BIT1(n)         (1ul<<n)
#define BIT3(n)         (3ul<<n)
#define BIT7(n)         (7ul<<n)

void TFT_init()
{
//  mTFT_SETUP_IO();

    TFT_CS_1;
    TFT_RD_1;
    TFT_WR_1;

    TFT_RESET_0; wait_ms(20);
    TFT_RESET_1; wait_ms(50);
    
    TFT_CS_0;
    for (int i = 0; ; i += 2) {
        if (TFT_Init_table[i] == WW) {          // Delay or Exit
            if (TFT_Init_table[i + 1] == 0)     // Exit(End of Init Table)
                break;                          // ..
            else
                wait_ms(TFT_Init_table[i + 1]);// Delay
        } else
            TFT_wr_index_data(TFT_Init_table[i], TFT_Init_table[i + 1]);
    }
    TFT_setOrientation(TFT_HV_HORZ);
    TFT_setWindow(TFT_info.xMIN, TFT_info.yMIN, TFT_info.xMAX, TFT_info.yMAX);
}


#if defined(_ARCH_PRO)
void TFT_wr_regs(uint8_t regv)
{
  #if defined(aitendo26) || defined(mcufriend24)
    // dbit  76543210 - data bit
    // pin#  76543298 - Digital pin# in Arduino
    // port# 22220000 - Port# in ARCH Pro
    // bit#  54325410 - Bit#  in ARCH Pro
    LPC_GPIO0->FIOCLR = BIT1( 1)|BIT1( 0)|BIT1( 5)|BIT1( 4);    // All low
    LPC_GPIO2->FIOCLR = BIT1( 5)|BIT1( 4)|BIT1( 3)|BIT1( 2);    // ..    
    LPC_GPIO0->FIOSET = (regv & (BIT1( 3)|BIT1( 2))) << 2 | (regv & (BIT1( 1)|BIT1( 0)));
    LPC_GPIO2->FIOSET = (regv & (BIT1( 7)|BIT1( 6)|BIT1( 5)|BIT1( 4))) >> 2;
  #endif
}
#else

// Can't use too slow
BusOut  TFTBus(D8, D9, D2, D3, D4, D5, D6, D7);
#define TFT_wr_regs(regv)   TFTBus = (regv)

#endif
