#include "mbed.h"
#include "SDFileSystem.h"
SDFileSystem sd(p5, p6, p7, p8, "sd");

int Load_Font16(uint16_t req, uint8_t *buff)
{
    static FILE *fp = 0;

    if ((fp == 0) || (req == 0xFFF0)) {
        fp = fopen("/sd/jiskan16.fnt", "rb");
        if (req == 0xFFF0) return((fp) ? 0 : -1);
    }

    if (req == 0xFFF1) {
        fclose(fp);
        return(0);
    }

    if (fseek(fp, (req * 32L), SEEK_SET) != -1) {
        fread(buff, 1, 32, fp);
        return(0);
    }
    return(-1);
}

void Disp_Font16(uint16_t k)
{
    uint8_t buff[16][2];

    k -= (k > 0x9FFC) ? (0x8140 + 0x4000) : 0x8140;
    if (k & 0x00C0) k--;
    k = ((k >> 8) * 94 * 2) + (k & 0x00FF);

    Load_Font16(k, buff[0]);

    for (int y = 0; y < 16; y++) {
        for (int x = 0; x < 2; x++) {
            for (uint8_t m = 0x80; m; m >>= 1) {
                printf((buff[y][x] & m) ? "o" : ".");
            }
        }
        printf("\n");
    }
    printf("\n");
}


void Disp_KANJI(uint16_t *s)
{
    while(*s) Disp_Font16(*s++);
}

uint16_t kstr[] = {
    0x93FA, 0x967B, 0x8CEA, 0x955C, 0x8EA6, 0x82CC, 0x8365, 0x8358, 0x8367, 0x82C5, 0x82B7, 0x8142
    , 0
};


int main()
{
    Disp_KANJI(kstr);

    uint16_t ds = 0x93FA;
    uint16_t de = 0x94FF;

    for ( ; ds < de; ds++) {
        if (ds < 0x8140) continue;
        if (ds > 0xE0FC) break;
        if ((ds & 0x00FF) <  0x40) continue;
        if ((ds & 0x00FF) == 0x7F) continue;
        if ((ds & 0x00FF) >  0xFC) continue;

        printf("%04X:\n", ds);
        Disp_Font16(ds);
    }
}
