#include "Lcd.h"
#include "mbed.h"


// Constructeur

Lcd::Lcd(PinName tx, PinName rx,int bauds) : Serial(tx, rx)
{
    Serial::baud(bauds);
}

void Lcd::Cls()
{
    char MonChar;
    MonChar=0x1b;
    this->putc(MonChar);
    MonChar=0x43;
    this->putc(MonChar);

}
//############## Poly  #################################################"
void Lcd::LCD(string Para1,string Para2)
{
    LcdS(Para1,Para2);
}
void Lcd::LCD(char Format[] ,float MonFloat)
{
    LcdF( Format, MonFloat);
}
void Lcd::LCD(float MonFloat)
{
    //<<<<<<< IMPRESSION FINALE >>>>>>>>>>>>>>>>>>>>
    this->printf("%f",MonFloat);
}
void Lcd::LCD(char masque[],int MonInt)
{
    LcdI(masque,MonInt);

}
void Lcd::LCD(int MonInt)
{
    //<<<<<<< IMPRESSION FINALE >>>>>>>>>>>>>>>>>>>>
    this->printf("%i",MonInt);
}

//############## INTEGER #################################################"
void Lcd::LcdI(int MonInt)
{
    //<<<<<<< IMPRESSION FINALE >>>>>>>>>>>>>>>>>>>>
    this->printf("%i",MonInt);
}
//############## INTEGER #################################################"
void Lcd::LcdI(char masque[],int MonInt)
{
    char Format[50];
    int i=0;
    int j=0;
    int k,l,c;
    Format[0]='*';
    // Extrait Position x y
    while(masque[i]!= 0) {

        if(masque[i]==94) {
            i++;
            l=masque[i]-48;
            i++;
            c=masque[i]-48;
            i++;// espace apres format
        } else {
            Format[j+1]=masque[i];
            j++;
        }
        i++;
    }

    //-------------------------------------------
    // détermintion de la position différente de numerique
    for (k=j; (k>0) ; k--) {
        if(!((Format[k]>=48 && Format[k]<=57)||(Format[k]==46))) {
            break;
        }

    }

    Format[j+1]='i';



    Format[j+2]=0;

    //---------------------------------
    //Cas 1 caractère Espace on décale à droite pour le conserver
    if (k==1) {
        for(int w=j+1; w!= 1; w--) {
            Format[w+1]=Format[w];
        }
        k++;
    }
    //Insere le %
    Format[k]='%';
    //Cas du Texte on décale à gauche
    if (Format[0]=='*') {
        for(int i=0; i<(j+3); i++) {
            Format[i]=Format[i+1];
        }
    }
    //Test si pos x/y
    if (j!=i) {
        this->putc(0x1b);
        this->putc(0x4c);
        this->putc(c);
        this->putc(l);
    }
    //<<<<<<< IMPRESSION FINALE >>>>>>>>>>>>>>>>>>>>
    this->printf(Format,MonInt);
    //this->printf("%s",Format);
}

//############## Float  #################################################"
void Lcd::LcdF(float MonFloat)
{
    //<<<<<<< IMPRESSION FINALE >>>>>>>>>>>>>>>>>>>>
    this->printf("%f",MonFloat);
}

//############## FLOAT #################################################"
void Lcd::LcdF(char masque[],float MonFloat)
{
    char Format[50];
    int i=0;
    int j=0;
    int k,l,c;
    Format[0]='*';
    // Extrait Position x y
    while(masque[i]!= 0) {
        if(masque[i]==94) {
            i++;
            l=masque[i]-48;
            i++;
            c=masque[i]-48;
            i++;// espace apres format
        } else {
            Format[j+1]=masque[i];
            j++;
        }
        i++;
    }
    Format[j+1]='f';
    Format[j+2]=0;
    //-------------------------------------------
    // détermintion de la position différente de numerique
    for (k=j; (k>0) ; k--) {
        if(!((Format[k]>=48 && Format[k]<=57)||(Format[k]==46))) {
            break;
        }
    }
    //---------------------------------
    //Cas 1 caractère Espace on décale à droite pour le conserver
    if (k==1) {
        for(int w=j+1; w!= 1; w--) {
            Format[w+1]=Format[w];
        }
        k++;
    }
    //Insere le %
    Format[k]='%';
    //Cas du Texte on décale à gauche
    if (Format[0]=='*') {
        for(int i=0; i<(j+3); i++) {
            Format[i]=Format[i+1];
        }
    }
    //Test si pos x/y
    if (j!=i) {
        this->putc(0x1b);
        this->putc(0x4c);
        this->putc(c);
        this->putc(l);
    }
    //<<<<<<< IMPRESSION FINALE >>>>>>>>>>>>>>>>>>>>
    this->printf(Format,MonFloat);
}


//############## STRING #################################################"
void Lcd::LcdS(string Param1,string Data)
{
    char masque[50];
    if (Data=="") {
        Data=Param1;
        Param1="";
    }


    for(int i=0; i<49; i++) {
        masque[i]=Param1[i];
    }
    char Format[50];
    int i=0;
    int j=0;
    int l,c;
    Format[0]='*';

    // Extrait Position x y
    while(masque[i]!= 0) {
        if(masque[i]==94) {
            i++;
            l=masque[i]-48;
            i++;
            c=masque[i]-48;
            i++;
            if ( masque[i]==0) {
                break;
            }



        } else {
            Format[j+1]=masque[i];
            j++;
        }
        i++;
    }

    /*
    //-------------------------------------------
    // détermintion de la position différente de numerique
    for (k=j; (k>0) ; k--) {
        if(!((Format[k]>=48 && Format[k]<=57)||(Format[k]==46))) {break;}
    }
    */

    //Insere le %
    Format[j+1]='%';
    Format[j+2]='s';
    Format[j+3]=0;

    //Cas du Texte on décale à gauche
    if (Format[0]=='*') {
        for(int i=0; i<(j+3); i++) {
            Format[i]=Format[i+1];
        }
    }
    //Test si pos x/y
    if (j!=i) {
        this->putc(0x1b);
        this->putc(0x4c);
        this->putc(c);
        this->putc(l);
    }
    //<<<<<<< IMPRESSION FINALE >>>>>>>>>>>>>>>>>>>>

    //this->printf("%s",Format);
    this->printf(Format,Data);

}