#include "mbed.h"

/*  THIS PROGRAM IS WRITTEN FOR THE FRDM-Kl25Z BUT CAN BE ADAPTED TO ANY MBED BOARD
    
    To use this program you need to add a bit of hardware: A single wire from "D1" to "D3." 
    
    
    Here's how it works: The PWN, the interrupt, and the LED are all set up with the first three lines.
    
    Next, a one-line function is defined to toggle the blue LED.
    
    The program enters the main() program area and makes sure the blue light is turned off.
    Yep, on this system apparently '1' means OFF and '0' means 'ON.'
    
    Next, the PWM parameters are set followed by the interrupt parameters
    
    Then, the program enters an endless while() loop with nothing in it.
    
    Upon reset, the PWM begins sending a steady pulse out of the PTD5 pin
    
    If PTD5 pulses "high" and is connected to the PTD3 pin then it triggers an interrupt which directs
    program control to the toggler() function which toggles the blue LED, (it turns it 'ON' if it is already 'OFF'
    or turns it 'OFF' if it is already 'ON.')
    
    After returning from the interrupt handling routine, toggler(), the program returns to the while() loop
    to await the next interrupt.
    
    Experiment with removing the wire from PTD5 and connecting the free end to ground.
    
    Try changing the LED DigitalOut assignment from PTD1 to PTB19 or PTB18.
    
    Look up the functions and fiddle around with the PWM parameters.
    
    BTW, "PT" as in "PTB19" or "PTD3" stands for "PORT."  And the "D" or "B" stands for Port D or Port B.
    The number after it is its pin number in the port.  So, PTB18 means Port B pin #18.    
*/


 // The PWM setup for PTD5
 // PTD5 is the "D5" pin 
 // on the FRDM-KL25Z
 
PwmOut pulseout(PTD5);
 
 // The interrupt setup for PTD3
 // PTD3 is the "D3" pin
 // on the FRDM-KL25Z
InterruptIn pulsein(PTD3);
  
 // The LED that will be
 // toggled to indicate
 // an incoming pulse from
 // the PTD5 pin to the
 // PTD3 pin.
 // PTD1 is the blue
 // LED on the FRDM-KL25Z
DigitalOut blue(PTD1);

 
 // The LED toggling function
void toggler(){ blue = !blue; }

int main() {

    blue = 1;
    
        // PWM pin parameters
    pulseout.period_ms(20);     // total pulse time "OFF" and "ON".
    pulseout.pulsewidth_ms(10); // pulse "ON" time.
    
        // Interrupt pin parameters
        
          // Pin is set to pull up
    pulsein.mode(PullNone);
          // Pin triggers an intertupt
          // the rising edge and turns
          // control over to the 
          // function toggler().
    pulsein.rise(&toggler); 
    
 // While awaiting an interrupt
 // the program simply cycles
 //in an empty while loop.
while(1) {}
}

