#include "mbed.h"
#include "USBHostMSD.h"
#include "MobiusCam.h"

void MobiusCam::clip(int t) {      // take a clip for t seconds
    printf("Start a clip\r\n");
    _camUSB = 0;
    Thread::wait(200);
    _camV5V = 1;
    Thread::wait(t * 1000);
    printf("Stop the clip\r\n");
    _camUSB = 0;
    _camV5V = 0;
    Thread::wait(1000);
}

void MobiusCam::directory(char *buf, int bufLen) {     
    printf("Start the camera\r\n");
    _camUSB = 1;
    Thread::wait(200);
    _camV5V = 1;
    Thread::wait(7000);
    printf("Try to connect the MSD device\r\n");
    int cnt = 0;
    while(!_msd.connect() && (cnt++ < 5)) {
        Thread::wait(500);
    }
    if (cnt < 5) {
        printf("MSD device connected\r\n");
        DIR *d = opendir("/usb/DCIM/101HDDVR");
        //DIR *d = opendir("/usb/DCIM");
        if (d != NULL) {
            struct dirent *p;
            uint32_t counter = 0;              
            printf("Lecture du repertoire ...\r\n");
            while ((p = readdir(d)) != NULL) {
                counter++;
                printf("%s\r\n", p->d_name);   
            }
            closedir(d);
            printf("\r\nFin de lecture du repertoire\r\n");
        }
        else
            printf("No directory\r\n");
    }
    else
        printf("MSD device NOT connected\r\n");
    Thread::wait(500);        
    printf("Stop the camera\r\n");
    _camUSB = 0;
    _camV5V = 0;
    Thread::wait(1000);
}    