/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */
//simple code for testing effect of pwm update rate of on motor performance 
//this is code for update at 2300us
//increment function is called at intervals of 2300us 
//or u can use your button to increment at your requirement
#include "mbed.h"
#include "platform/mbed_thread.h"

int i=1000;
Ticker timer;

PwmOut u(PE_9);//create an object u associated with your pin u need pwm from(PE_9 in my case)
void incr(void){
    if(i>2000)
    i=1800;
    i++;
    }
int main()

{   
    u.pulsewidth_us(2000);
    wait(4);
    u.pulsewidth_us(1000);
    wait(3);
    
    u.period_us(20000);//set frequency of pwm to 50hz as ESC works on 50Hz
    
    timer.attach_us(&incr,2300);
    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);

    while (true) {
        u.pulsewidth_us(i);
      
    }
}
