#include "mbed.h"
#include "SparkFun-Si4703.h"
#include "TextLCD.h"

Serial pc(USBTX, USBRX);
Si4703_Breakout radio(p28, p27, p26, &pc); // (sda, scl, rst, Serial)
DigitalIn chanUp(p17);
DigitalIn chanDown(p18);
DigitalIn volUp(p19);
DigitalIn volDown(p20);
TextLCD lcd(p16, p15, p14, p13, p12, p11); // rs, e, d4-d7



int main(int argc, char** argv) {
    
    int chan = 901;
    int vol = 9;
    radio.powerOn();
    radio.setVolume(vol); // range: 0-15
    radio.setChannel(chan); // 90.1 WABE  
    
    lcd.cls(); 
    lcd.printf("channel = '%d'", radio.getChannel());  
    lcd.printf(" volume = '%d'\n", radio.getVolume());  
    pc.printf("channel = '%d'", radio.getChannel());  
    pc.printf(" volume = '%d'\n", radio.getVolume());  
 
    
    while(1){
        if(chanUp) {
            chan++;
            radio.setChannel(chan);
            lcd.cls();
            lcd.printf("channel = '%d'", radio.getChannel());  
            lcd.printf(" volume = '%d'\n", radio.getVolume());  
            pc.printf("channel = '%d'", radio.getChannel());  
            pc.printf(" volume = '%d'\n", radio.getVolume());  
            wait(.25);
        }
                if(chanDown) {
            chan--;
            radio.setChannel(chan);
            lcd.cls();
            lcd.printf("channel = '%d'", radio.getChannel());  
            lcd.printf(" volume = '%d'\n", radio.getVolume());  
            pc.printf("channel = '%d'", radio.getChannel());  
            pc.printf(" volume = '%d'\n", radio.getVolume());  
            wait(.25);
        }
                if(volUp && vol <= 14) {
            vol++;
            radio.setVolume(vol);
            lcd.cls();
            lcd.printf("channel = '%d'", radio.getChannel());  
            lcd.printf(" volume = '%d'\n", radio.getVolume());  
            pc.printf("channel = '%d'", radio.getChannel());  
            pc.printf(" volume = '%d'\n", radio.getVolume());  
            wait(.25);
        }
                if(volUp && vol == 15) {
            lcd.cls();
            lcd.printf("channel = '%d'", radio.getChannel());  
            lcd.printf(" Max Volume\n", radio.getVolume()); 
            pc.printf("Max Volume\n");
            wait(.25);
        }
                if(volDown && vol >= 1) {
            vol--;
            radio.setVolume(vol);
            lcd.cls();
            lcd.printf("channel = '%d'", radio.getChannel());  
            lcd.printf(" volume = '%d'\n", radio.getVolume());  
            pc.printf("channel = '%d'", radio.getChannel());  
            pc.printf(" volume = '%d'\n", radio.getVolume());  
            wait(.25);
        }
                if(volDown && vol == 0) {
            lcd.cls();
            lcd.printf("channel = '%d'", radio.getChannel());  
            lcd.printf(" Min Volume\n", radio.getVolume());  
            pc.printf("Min Volume\n");
            wait(.25);
        }

    }
}