#include "mbed.h"
#include "GPS.h"

Serial pc(USBTX, USBRX);
GPS gps(p9, p10);
DigitalOut led1(LED1);
Timer T;
bool cutdown=0;
DigitalOut relay(p8);
bool attempted=0;
DigitalIn DTMF(p11);
AnalogIn Temp1(p18);
AnalogIn Temp2(p19);
AnalogIn Temp3(p20);

int main() {
    T.start();
    relay=0;
    float tempC1, tempF1, tempC2, tempF2, tempC3, tempF3;
    while(1) {
        
        pc.printf("----- %f -----\n\r",T.read());
            if(T.read()>= 20){
                cutdown=1;
                }
                
        gps.sample();
        pc.printf("Long = %f\n\rLati = %f\n\r", gps.longitude, gps.latitude);
        if(gps.longitude != 0){
                led1=1;
        }
        
        tempC1 = ((Temp1*3.3)-0.600)*100.0;
        tempC2 = ((Temp2*3.3)-0.600)*100.0;
        tempC3 = ((Temp3*3.3)-0.600)*100.0;
        tempF1 = (9.0*tempC1)/5.0 + 32;
        tempF2 = (9.0*tempC2)/5.0 + 32;
        tempF3 = (9.0*tempC3)/5.0 + 32;
        pc.printf("Temp1 = %f\n\rTemp2 = %f\n\rTemp3 = %f\n\r",tempF1, tempF2, tempF3);
        
        if (DTMF){
            pc.printf("DTMF = True\n\r");
            cutdown=1;
            } else {
                pc.printf("DTMF = False\n\r");
                }

if (cutdown==1 && attempted != 1){
        pc.printf("Cutdown Started = %f\n\r",T.read());
        relay=1;
        wait(20);
        relay=0;
        pc.printf("Cutdown Ended = %f\n\r",T.read());
        attempted=1;
        }
        
        }
    }

