#include "mbed.h"
#include "string.h"

AnalogIn y(PTB3);//entrada analoga
AnalogOut u(PTE30);//salida analoga OJO solo se le pueden drenar 1.5mA en circuitos use un Buffer
//si se ignora esto se arruina la FRDMKL25Z
//Serial HC06(USBTX, USBRX, "HC06");
Serial HC06(PTE0,PTE1);

char buffer[128];
char c;
int readptr = 0;
int Kp, Ki, Kd, Sp;
float pid,o,ai,ad,ap,med,err;
float err_v;
int checker1, checker2, checker3, checker4;

int conv(){
    readptr = 0;
    while( (c = HC06.getc()) != '\n') {
            buffer[readptr++] = c;
    }
    buffer[readptr++] = 0;
    
    //HC06.printf("buffer= %s\n\r ",buffer);  //imprime el bufer
    //HC06.printf("buffer= %c  %c\n\r ",buffer[0],buffer[1]);//imprime el cero y el uno
    
    char *s1 = buffer;
    int num = atoi(s1);
    
    //HC06.printf("Num: %d", num);
    
    return num;
}

void cleanBuffer(char *buffer, int count)  //esta funcion limpia el bufer
{
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
}

int main(){
    
// Bluetooth
    HC06.baud(9600);
    HC06.printf("CONTROLADOR PID BLUETOOTH\n");

// Interfaz para el HC06
    HC06.printf("***********************************************\n");
    HC06.printf("CONTROLADOR PID \n");
    HC06.printf("***********************************************\n");
    HC06.printf("* Menu para los parametros del controlador PID: \n\n");
    HC06.printf("* Kp - Ingresar valor de la consotante proporcional \n");
    HC06.printf("* Ki - Ingresar valor de la consotante integral \n");
    HC06.printf("* Kd - Ingresar valor de la consotante derivativa \n");
    HC06.printf("* Sp - Ingresar valor del Set-Point \n\n");
        
    while(1){
        
        // Analizamos lo que ingresa el usuario
        while( (c = HC06.getc()) != '\n') {
            buffer[readptr++] = c;
        }
        buffer[readptr++] = 0;
        
        //HC06.printf("buffer= %s\n\r ",buffer);  //imprime el bufer
        //HC06.printf("buffer= %c  %c\n\r ",buffer[0],buffer[1]);//imprime el cero y el uno
        
        //////////////////////////////////////////
        
        if (strncmp(buffer, "Kp", 2) == 0) {
            //Se lee el valor para Kp
            cleanBuffer(buffer,5);
            HC06.printf("Ingrese el valor para Kp: ");
            Kp = conv();
            checker1=1;
        }
        else if (strncmp(buffer, "Ki", 2) == 0) {
            //Se lee el valor para Ki
            cleanBuffer(buffer,5);
            HC06.printf("Ingrese el valor para Ki: ");
            Ki = conv();
            checker2=1;
        }
        else if (strncmp(buffer, "Kd", 2) == 0) {
            //Se lee el valor para Kd
            cleanBuffer(buffer,5);
            HC06.printf("Ingrese el valor para Kd: ");
            Kd = conv();
            checker3=1;
        }
        else if (strncmp(buffer, "Sp", 2) == 0) {
            //Se lee el valor para Sp
            cleanBuffer(buffer,5);
            HC06.printf("Ingrese el valor para Sp: ");
            Sp = conv();
            if(Sp<=0){Sp=0;}
            if(Sp > 999){Sp=999;}
            checker4=1;
        }
        else {
            HC06.printf("Syntax error \n");       
        }
        readptr = 0;
        //buffer[0]='\0';
        //buffer[1]='\0';
        //buffer[2]='\0';
        
        if (checker1 == 1 && checker2 == 1 && checker3 == 1 && checker4 == 1 ){
            HC06.printf("Parametros listos para iniciar \n");
            HC06.printf("*************************************\n");
            HC06.printf("Iniciar ahora (Si/No) \n");
            
            //Se lee la elección del usuario
           while(1){
                while( (c = HC06.getc()) != '\n') {
                    buffer[readptr++] = c;
                }
                buffer[readptr++] = 0;
                
                if (strncmp(buffer, "Si", 2) == 0){
                    HC06.printf("* Ingrese 'P' si desea cambiar el Set Ponit  \n\n");
                    HC06.printf("Iniciando... \n\n");
                    wait_ms(1000);
                    break;
                }  
                else{
                    HC06.printf("Iniciar ahora (Si/No) \n");
                }
            readptr = 0;
            }
            break;
        }else{
            HC06.printf("*************************************\n");
            HC06.printf("Ingrese los valores restantes \n");
            HC06.printf("*************************************\n");
            }
        HC06.printf("\n");
    }
    
    // CICLO PRINCIPAL CONTROLADOR PID
    
    lop1:  
        med = y.read()*999;
        err = (Sp-med);  //se calcula el error
        ap = Kp*err*0.01f;     //se calcula la accion proporcinal
        ai =(Ki*err*0.01f)+ai;    //calculo de la integral del error
        ad = Kd*(err-err_v)*0.01f; //calculo de la accion derivativa
        pid = (ap+ai+ad);
        // se verifica que pid sea positivo **************************************
        if(pid<=0)
        {
            pid=0;
        }

        // se verifica que pid sea menor o igual al valor maximo *****************
        if (pid > 999)
        {
            pid=999;
        }
        
        //Normalizacion de la salida
        // se actualizan las variables *******************************************
        err_v = err;
        o = pid/999;
        u.write(o); //  se envia el valor pid a puerto analogico de salida (D/A) **************
        
        /*HC06.printf("SetPoint\tEntrada\t\tError\t\tSalida\n");
        HC06.printf("%d\t\t%0.2f\t\t%0.2f\t\t%0.2f\n",Sp,med,err,pid);
        HC06.printf("%0.2fV\t\t%0.2fV\t\t%0.2fV\t\t%0.2fV\n\n",((Sp*3.3)/1000),((med*3.3)/1000),((err*3.3)/1000),((pid*3.3)/1000));*/
        
        HC06.printf("SetPoint: %d       %0.2fV\n\r",Sp,((Sp*3.3)/1000));
        HC06.printf("Entrada:  %0.2f    %0.2fV\n\r",med,((med*3.3)/1000));
        HC06.printf("Error:    %0.2f    %0.2fV\n\r",err,((err*3.3)/1000));
        HC06.printf("Salida:   %0.2f    %0.2fV\n\r",pid,((pid*3.3)/1000));
        HC06.printf("\n\r");
        
        ////-----------------------Nuevo Setpoint-------------------------------------------
        if(HC06.readable()){
            if ((c = HC06.getc()) == 'P') {
                buffer[readptr++] = c;
            }
            buffer[readptr++] = 0;
            //HC06.printf("buffer= %s\n\r ",buffer);  //imprime el bufer
            //HC06.printf("buffer= %c  %c\n\r ",buffer[0],buffer[1]);//imprime el cero y el uno
        }
        if (strncmp(buffer, "P", 1) == 0){
            buffer[0]='\0';
            HC06.printf("* Ingrese el nuevo SetPoint: ");
            HC06.scanf("%d", &Sp);
            if(Sp<=0){Sp=0;}
            if(Sp > 999){Sp=999;}
            HC06.printf("Iniciando... \n\n");
            wait_ms(1000);
        }  

        readptr = 0;
        /////------------------------------------------------------------------
        
        //  se repite el ciclo
        wait_ms(500);
        goto lop1;
}
