#define SCLK    PTC5
#define IO      PTC4
#define CE      PTC3

//Comment this line if the DS1302 is already running
#define INITIAL_RUN

#include "mbed.h"
#include "DS1302.h"

DS1302 clk(SCLK, IO, CE);

int main() {
    #ifdef INITIAL_RUN
    clk.set_time(1256729737);
    #endif
    
    char storedByte = clk.recallByte(0);
    printf("\r\nStored byte was %d, now increasing by one\r\n", storedByte);
    clk.storeByte(0, storedByte + 1);
    
    while(1) {
        time_t seconds = clk.time(NULL);
        printf("Time as a basic string = %s\r", ctime(&seconds));
        wait(1);
    }
}
