#ifndef IMU_H
#define IMU_H

#include "mbed.h"

#define TEMP_OUT 0x02
#define XGYRO_OUT 0x04
#define YGYRO_OUT 0x06
#define ZGYRO_OUT 0x08
#define XACCL_OUT 0x0A
#define YACCL_OUT 0x0C
#define ZACCL_OUT 0x0E

#define CR 0x0D

#define BAUDRATE 57600


class IMU {

    public:
        IMU(PinName tx, PinName rx);
        ~IMU();
        signed int getParam(unsigned char par); 
        float getScaledParam(unsigned char par); 
        
        
    private:
        Serial *s_;
        bool faulty;
        
        void init(Serial *s);
        bool isReady();
        bool isFaulty();
        void goToStartOfSentence(unsigned char par);
        
        


};


#endif