#include "mbed.h"
#include "SDFileSystem.h"
#include "FATFileSystem.h"

Serial pc(USBTX, USBRX,9600);
Serial pms(PA_9, PA_10,9600); // le capteur est en fait un port série, on configure le port
SDFileSystem sd (PA_12, PA_11, PA_1, PB_0,"sd"); // creation du port de la carte sd
DigitalOut led (LED1); // led pouvant être pilotée en cas de besoin pour vérifier le bon déroulement du code


int b1 = 0; // variables dans lesquelles vontt être stockées les données
int b2 = 0;
int b3 = 0;
int b4 = 0;
int b5 = 0;
int b6 = 0;
int b7 = 0;
int b8 = 0;
int b9 = 0;
int b10 = 0;
int b11 = 0;
int b12 = 0;

unsigned long b13; // variables utilisées dans la conversion du texte
char b14[1000]= {0};

FILE *fp = NULL; // pointeur permettant d'ouvrir, de créer et d'écrire dans des fichiers

int g = 0; // variables qui sont utilisées pour l'incrémentation de certaines boucles
int a = 0;
int gg = 0;
int buff[32] = {0};
char buffer[32];
int b = 0;
char check[4] = {0};
char h;
int ggg = 0;

int main()
{

    b13 = 0;
    set_time(1559752200);// réglage de l'horloge interne, il s'agit du temps écoulé en secondes depuis le 1er Janvier 1970 à 00:00:00
    sprintf(b14,"/sd/test_%d.csv",b13); // on écrit le texte qui va nous permettre de changer le nom du fichier et on le stocke dans le buffer b14

    fp = fopen(b14,"r"); // on lit le fichier qui s'appelle test0, si et on stocke la 1ère lettre lue dans la variable ggg, si le fichier n'existe pas alors il sera créer
    ggg = fgetc(fp); // si le fichier est vide alors ggg = 0
    fclose(fp); // on ferme le fichier

    while (ggg == 104) { // si il y a des données dans le fichier alors le 1er caractère est un h, ce qui équivaut à 104

        b13++; // on incrémente la valeur de b13 pour changer le numéro du fichier
        sprintf(b14,"/sd/test_%d.csv",b13);
        fp = fopen(b14,"r");
        ggg = fgetc(fp);
        fclose(fp);
    }

    if(ggg != 104) { // si on le lit pas le h alors on écrit dans ce fichier et on enregistre nos données
        sprintf(b14,"/sd/test_%d.csv",b13);
        fp = fopen(b14,"w");
        fprintf(fp,"heure;PM1.0(microg/m3);PM2.5(microg/m3);PM10(microg/m3);PM1.0 EA(microg/m3);PM2.5 EA(microg/m3);PM10 EA(microg/m3);nb part >0.3microm;nb part >0.5microm;nb part >1.0microm;nb part >2.5microm;nb part >5.0microm;nb part >10microm");
        fclose(fp);
    } else {}

    while(1) {

        time_t seconds = time(NULL);
        strftime(buffer, 32, "%I:%M:%S %p", localtime(&seconds));
        gg = 0;
        led = 0;
        Serial pc(USBTX, USBRX,9600);
        Serial pms(PA_9, PA_10,9600);

        while(gg <= 31) { // on range les octets dans les variables du tableau
            if (pms.readable() == 1) {
                buff[gg] = pms.getc(); // on lit des trames de données de 32 octets
                gg++;
                b1 = buff[4]<<8|buff[5]; // seuls les octets allant de 4 à 27 possèdes les données dont nous avons besoin
                b2 = buff[6]<<8|buff[7];
                b3 = buff[8]<<8|buff[9];
                b4 = buff[10]<<8|buff[11];
                b5 = buff[12]<<8|buff[13];
                b6 = buff[14]<<8|buff[15];
                b7 = buff[16]<<8|buff[17];
                b8 = buff[18]<<8|buff[19];
                b9 = buff[20]<<8|buff[21];
                b10 = buff[22]<<8|buff[23];
                b11 = buff[24]<<8|buff[25];
                b12 = buff[26]<<8|buff[27];
            } else {}
        }

        if (buff[0] == 0x42 and buff[1] == 0x4D and buff[2] == 0x00 and buff[3] == 0x1C) { // les 1er octets nous permettent de vérifier la conformité des données car il nous donne des informations sur la longueur de la trame en plus de des caratères de début de trame

            pc.printf("\n\rTime as a custom formatted string = %s", buffer);
            fp = fopen(b14, "a"); // après vérification on écrit les données dans le fichier.csv et on utilise les points virgules en tant que séparateurs
            fprintf(fp,"\r%s;%i;%i;%i;%i;%i;%i;%i;%i;%i;%i;%i;%i",buffer,b1,b2,b3,b4,b5,b6,b7,b8,b9,b10,b11,b12);
            fclose(fp);
            pc.printf("\n\r,success !");
            led = 1; // on allume quand l'enregistrement a été effectué avec succès
        } else {}
    }
}
