#include "mbed.h"
// For EEPROM, 최대 16byte 씩 쓸 수 있음 
// M95128-WMN6P 

// Board Information
uint8_t BNO = 0;
uint8_t CONTROL_MODE = 0;
uint8_t OPERATING_MODE = 0; // (00 : Moog & Rot, 01 : Moog & Lin, 10 : KNR & Rot, 11 : KNR & Lin, 101 : SW & Lin)
uint8_t SENSING_MODE = 0; // (0 : torque, 1: pressure)
uint8_t CONTROL_UTILITY_MODE = 0;
uint8_t CURRENT_CONTROL_MODE = 0; // (0 : pwm, 1 : current control)
uint8_t FLAG_VALVE_DEADZONE = 0;
uint8_t REFERENCE_MODE = 0;
int16_t CAN_FREQ = 500;
int16_t DIR_JOINT_ENC = 0;
int16_t DIR_VALVE = 0;
int16_t DIR_VALVE_ENC = 0;

float SUPPLY_VOLTAGE = 12.0f;
float VALVE_VOLTAGE_LIMIT = 12.0f;  //v

float P_GAIN_VALVE_POSITION = 0.0f;
float I_GAIN_VALVE_POSITION= 0.0f;
float D_GAIN_VALVE_POSITION= 0.0f;
float P_GAIN_JOINT_POSITION = 0.0f;
float I_GAIN_JOINT_POSITION = 0.0f;
float D_GAIN_JOINT_POSITION = 0.0f;
float P_GAIN_JOINT_TORQUE = 0.0f;
float I_GAIN_JOINT_TORQUE = 0.0;
float D_GAIN_JOINT_TORQUE = 0.0;

int16_t K_SPRING = 0.0;
int16_t D_DAMPER = 12.0;
int16_t flag_delay_test = 0;

//float P_GAIN_VALVE_POSITION_OPP = 0.0f;
//float I_GAIN_VALVE_POSITION_OPP= 0.0f;
//float D_GAIN_VALVE_POSITION_OPP= 0.0f;
//float P_GAIN_JOINT_POSITION_OPP = 0.0f;
//float I_GAIN_JOINT_POSITION_OPP = 0.0f;
//float D_GAIN_JOINT_POSITION_OPP = 0.0f;
//float P_GAIN_JOINT_TORQUE_OPP = 0.0f;
//float I_GAIN_JOINT_TORQUE_OPP = 0.0;
//float D_GAIN_JOINT_TORQUE_OPP = 0.0;

float VALVE_DEADZONE_PLUS;
float VALVE_DEADZONE_MINUS;

int16_t VELOCITY_COMP_GAIN;
int16_t COMPLIANCE_GAIN;

int16_t VALVE_CENTER;

int16_t VALVE_FF;

int16_t BULK_MODULUS;

int16_t CHAMBER_VOLUME_A;
int16_t CHAMBER_VOLUME_B;

int16_t PISTON_AREA_A;
int16_t PISTON_AREA_B;
float PISTON_AREA_alpha;
float alpha3 = 1.0f;


int16_t PRES_SUPPLY;
int16_t PRES_RETURN;

int16_t ENC_LIMIT_PLUS;
int16_t ENC_LIMIT_MINUS;

int16_t STROKE;


//int16_t VALVE_LIMIT_PLUS;
//int16_t VALVE_LIMIT_MINUS;

float ENC_PULSE_PER_POSITION;
float TORQUE_SENSOR_PULSE_PER_TORQUE;
float PRES_SENSOR_A_PULSE_PER_BAR = 4096.0f / 200.0f;
float PRES_SENSOR_B_PULSE_PER_BAR = 4096.0f / 200.0f;

int HOMEPOS_OFFSET;
int HOMEPOS_VALVE_OPENING;

float FRICTION;
float REF_PERIOD;
float REF_MAG;
int REF_NUM;


float DAC_REF;
float DAC_RESOL;

int REF_POSITION;
int REF_VELOCITY;
int16_t REF_TORQUE;
int16_t REF_PRES_DIFF;
int16_t REF_PWM;
int16_t REF_VALVE_POSITION;
int16_t REF_CURRENT;

int REF_MOVE_TIME_5k;
int INIT_REF_PWM;
int INIT_REF_VALVE_POS;
int INIT_REF_POS;
int INIT_REF_VEL;
int INIT_REF_TORQUE;
int INIT_REF_PRES_DIFF;
int INIT_REF_CURRENT;

int CUR_POSITION;
int CUR_VELOCITY;
float CUR_TORQUE;
float CUR_PRES_A;
float CUR_PRES_B;
int CUR_VALVE_POSITION;

unsigned int    TMR2_COUNT_LED1;
unsigned int    TMR2_COUNT_LED2;
unsigned int    TMR2_COUNT_CAN_TX = 0;
unsigned int    TMR3_COUNT_TEST = 0;

int num_err;
int flag_err[8];
int flag_err_old[8];
int flag_err_rt;

int flag_ref_enable;

int flag_data_request[5];

int MODE_POS_FT_TRANS = 0;

float CUR_CURRENT_mA = 0.0f;
float CUR_PRES_A_BAR = 0.0f;
float CUR_PRES_B_BAR = 0.0f;
float CUR_TORQUE_NM = 0.0f;
float CUR_TORQUE_NM_PRESS = 0.0f;

float PRES_A_VREF = 0.0f;
float PRES_B_VREF = 0.0f;
float TORQUE_VREF = 0.0f;

float VALVE_PWM_RAW_FB = 0.0f;
float VALVE_PWM_RAW_FF = 0.0f;
float VALVE_PWM_RAW = 0.0f;
int VALVE_PWM_VALVE_DZ = 0;

float VALVE_GAIN_LPM_PER_V[10];
float VALVE_POS_VS_PWM[25];
long JOINT_VEL[100];

int VALVE_MAX_POS;
int VALVE_MIN_POS;
int VALVE_POS_NUM;
float VALVE_CENTER_OFFSET;
float VALVE_DZ_MINUS_OFFSET;
float VALVE_DZ_PLUS_OFFSET;



//SPI device(PB_15, PB_14, PB_13);
//DigitalOut cs(PB_12);
SPI eeprom(PB_15, PB_14, PB_13); //MOSI, MISO, SCK
DigitalOut eeprom_cs(PB_12); // Chip select 
//DigitalOut check(PA_10);
Serial pc(PA_9,PA_10);
int temp1, temp2;
void spi_eeprom_ready(void);
void spi_eeprom_write(unsigned int data);
void spi_eeprom_write_long(void);
void spi_eeprom_write_long_1(unsigned int add);
void spi_eeprom_write_long_2(unsigned int add);
void spi_eeprom_write_long_3(unsigned int add);
void spi_eeprom_write_long_4(unsigned int add);
void spi_eeprom_write_long_5(unsigned int add);
void spi_eeprom_write_long_6(unsigned int add);
void spi_eeprom_write_long_7(unsigned int add);
void spi_eeprom_write_long_8(unsigned int add);
void spi_eeprom_write_long_9(unsigned int add);
void spi_eeprom_write_long_10(unsigned int add);
void spi_eeprom_write_long_11(unsigned int add);
void spi_eeprom_write_long_12(unsigned int add);
void spi_eeprom_write_long_13(unsigned int add);
unsigned int spi_eeprom_read(void);
void spi_eeprom_read_long(void);
void spi_eeprom_read_long_1(unsigned int add);
void spi_eeprom_read_long_2(unsigned int add);
void spi_eeprom_read_long_3(unsigned int add);
void spi_eeprom_read_long_4(unsigned int add);
void spi_eeprom_read_long_5(unsigned int add);
void spi_eeprom_read_long_6(unsigned int add);
void spi_eeprom_read_long_7(unsigned int add);
void spi_eeprom_read_long_8(unsigned int add);
void spi_eeprom_read_long_9(unsigned int add);
void spi_eeprom_read_long_10(unsigned int add);
void spi_eeprom_read_long_11(unsigned int add);
void spi_eeprom_read_long_12(unsigned int add);
void spi_eeprom_read_long_13(unsigned int add);
    int a=0x41233212;
    int b=0x32222222;
    int c=0x11112222;
    int d=0x11111111;
    int e=0x00002222;
 
int main() {
    eeprom.format(8,3);  
    eeprom.frequency(5000000); // max freq of eeprom 
    spi_eeprom_write_long(); 
    
    
    while(1){
        wait(3.0f);
        spi_eeprom_read_long();
        pc.printf("right=%d, ans=%d\n",b,D_DAMPER);
        for(int i=90; i<100; i++) {
            pc.printf("%dth right=%d, ans=%d\n",i,b,JOINT_VEL[i]);
        }
        for(int i=0; i<15; i++) {
            pc.printf("%dth right=%d, ans=%d\n",i,a,JOINT_VEL[i]);
        }
        wait(10.0f);
        
        /*
        pc.printf("a right=%d, ans=%d\n",a,BNO);
        pc.printf("a right=%d, ans=%f\n",a,P_GAIN_VALVE_POSITION);
        pc.printf("a right=%d, ans=%f\n",a,D_GAIN_JOINT_TORQUE);
        pc.printf("b right=%d, ans=%d\n",a,VALVE_FF);
        */
        /*
        pc.printf("c right=%d, ans=%f\n",c,VALVE_POS_VS_PWM[11]);
        pc.printf("d right=%d, ans=%d\n",d,JOINT_VEL[99]);
        pc.printf("e right=%d, ans=%d\n",e,D_DAMPER);
        */
    }    
}

void spi_eeprom_ready(void){
    int temp1, temp2;
    do{
        eeprom_cs=0;
        eeprom.write(0x06);  //write enable
        eeprom_cs=1;
        
        eeprom_cs=0;
        temp1 = eeprom.write(0x05);     
        temp2 = eeprom.write(0x00);
        eeprom_cs=1;
        temp2=(temp2&(0x03))!= 0x02;
    } while(temp2); // before writing or reading 
}

void spi_eeprom_write(unsigned int data){
        eeprom.write(0xff&data);
        eeprom.write(0xff&(data>>8));
        eeprom.write(0xff&(data>>16));
        eeprom.write(0xff&(data>>24));
}

void spi_eeprom_write_long(void){

    spi_eeprom_write_long_1(0x0000);
    spi_eeprom_write_long_2(0x0100);
    spi_eeprom_write_long_3(0x0200);
    spi_eeprom_write_long_4(0x0300);
    spi_eeprom_write_long_5(0x0400);
    spi_eeprom_write_long_6(0x0500);
    spi_eeprom_write_long_7(0x0600);
    spi_eeprom_write_long_8(0x0700);
    spi_eeprom_write_long_9(0x0800);
    spi_eeprom_write_long_10(0x0900);
    spi_eeprom_write_long_11(0x1000);
    spi_eeprom_write_long_12(0x1100);
    spi_eeprom_write_long_13(0x1200);
}


void spi_eeprom_write_long_1(unsigned int add){
        
        spi_eeprom_ready();
        eeprom_cs=0;
        eeprom.write(0x02);
        eeprom.write(0xff&(add>>8));
        eeprom.write(0xff&add);
        
        spi_eeprom_write((int) BNO);           // write at address, 쓸때도 4byte씩 씀
        spi_eeprom_write((int) OPERATING_MODE);
        spi_eeprom_write((int) SENSING_MODE);
        spi_eeprom_write((int) CURRENT_CONTROL_MODE);
        spi_eeprom_write((int) FLAG_VALVE_DEADZONE);
        spi_eeprom_write((int) CAN_FREQ);
        spi_eeprom_write((int) DIR_JOINT_ENC);
        spi_eeprom_write((int) DIR_VALVE);
        spi_eeprom_write((int) DIR_VALVE_ENC);
        spi_eeprom_write((int) (SUPPLY_VOLTAGE * 10.0f));
        spi_eeprom_write((int) (VALVE_VOLTAGE_LIMIT * 10.0f));
        spi_eeprom_write((int) P_GAIN_VALVE_POSITION);
        spi_eeprom_write((int) I_GAIN_VALVE_POSITION);
        spi_eeprom_write((int) D_GAIN_VALVE_POSITION);
        spi_eeprom_write((int) P_GAIN_JOINT_POSITION);
        
        eeprom_cs=1;
}

void spi_eeprom_write_long_2(unsigned int add){
        
        spi_eeprom_ready();
        eeprom_cs=0;
        eeprom.write(0x02);
        eeprom.write(0xff&(add>>8));
        eeprom.write(0xff&add);
        
        spi_eeprom_write((int) I_GAIN_JOINT_POSITION);
        spi_eeprom_write((int) D_GAIN_JOINT_POSITION);
        spi_eeprom_write((int) P_GAIN_JOINT_TORQUE);
        spi_eeprom_write((int) I_GAIN_JOINT_TORQUE);
        spi_eeprom_write((int) D_GAIN_JOINT_TORQUE);
        spi_eeprom_write((int) (VALVE_DEADZONE_PLUS * 10.0f));
        spi_eeprom_write((int) (VALVE_DEADZONE_MINUS * 10.0f));
        spi_eeprom_write((int) VELOCITY_COMP_GAIN);
        spi_eeprom_write((int) COMPLIANCE_GAIN);
        spi_eeprom_write((int) VALVE_CENTER);
        spi_eeprom_write((int) VALVE_FF);
        spi_eeprom_write((int) BNO);
        spi_eeprom_write((int) CHAMBER_VOLUME_A);
        spi_eeprom_write((int) CHAMBER_VOLUME_B);
        spi_eeprom_write((int) PISTON_AREA_A);
        
        eeprom_cs=1;
}

void spi_eeprom_write_long_3(unsigned int add){
        
        spi_eeprom_ready();
        eeprom_cs=0;
        eeprom.write(0x02);
        eeprom.write(0xff&(add>>8));
        eeprom.write(0xff&add);
        
        spi_eeprom_write((int) PISTON_AREA_B);
        spi_eeprom_write((int) PRES_SUPPLY);
        spi_eeprom_write((int) PRES_RETURN);
        spi_eeprom_write((int) ENC_LIMIT_MINUS);
        spi_eeprom_write((int) ENC_LIMIT_PLUS);
        spi_eeprom_write((int) STROKE);
        //writer.write(RID_VALVE_LIMIT_MINUS,(int) VALVE_LIMIT_MINUS);
        //writer.write(RID_VALVE_LIMIT_PLUS,(int) VALVE_LIMIT_PLUS);
        spi_eeprom_write((int) (ENC_PULSE_PER_POSITION*10.0f));
        spi_eeprom_write((int) (TORQUE_SENSOR_PULSE_PER_TORQUE * 10000.0f));
        spi_eeprom_write((int) (PRES_SENSOR_A_PULSE_PER_BAR * 100.0f));
        spi_eeprom_write((int) (PRES_SENSOR_B_PULSE_PER_BAR * 100.0f));
        spi_eeprom_write((int) (FRICTION * 10.0f));
        spi_eeprom_write((int) HOMEPOS_OFFSET);
        spi_eeprom_write((int) HOMEPOS_VALVE_OPENING);
        
        eeprom_cs=1;
}

void spi_eeprom_write_long_4(unsigned int add){
        
        spi_eeprom_ready();
        eeprom_cs=0;
        eeprom.write(0x02);
        eeprom.write(0xff&(add>>8));
        eeprom.write(0xff&add);       
        
        spi_eeprom_write((int) (TORQUE_VREF * 1000.0f));
        spi_eeprom_write( (int) (PRES_A_VREF * 1000.0f));
        spi_eeprom_write((int) (PRES_B_VREF * 1000.0f));
        spi_eeprom_write((int) (VALVE_GAIN_LPM_PER_V[0] * 100.0f));
        spi_eeprom_write((int) (VALVE_GAIN_LPM_PER_V[2] * 100.0f));
        spi_eeprom_write((int) (VALVE_GAIN_LPM_PER_V[4] * 100.0f));
        spi_eeprom_write((int) (VALVE_GAIN_LPM_PER_V[6] * 100.0f));
        spi_eeprom_write((int) (VALVE_GAIN_LPM_PER_V[8] * 100.0f));
        spi_eeprom_write((int) (VALVE_GAIN_LPM_PER_V[1] * 100.0f));
        spi_eeprom_write((int) (VALVE_GAIN_LPM_PER_V[3] * 100.0f));
        spi_eeprom_write((int) (VALVE_GAIN_LPM_PER_V[5] * 100.0f));
        spi_eeprom_write((int) (VALVE_GAIN_LPM_PER_V[7] * 100.0f));
        spi_eeprom_write((int) (VALVE_GAIN_LPM_PER_V[9] * 100.0f));
        
        eeprom_cs=1;
}
        
void spi_eeprom_write_long_5(unsigned int add){
        
        spi_eeprom_ready();
        eeprom_cs=0;
        eeprom.write(0x02);
        eeprom.write(0xff&(add>>8));
        eeprom.write(0xff&add);  
              
        for(int i=0; i<15; i++) {
            spi_eeprom_write( (int) VALVE_POS_VS_PWM[i]);
        }
        
        eeprom_cs=1;
}

void spi_eeprom_write_long_6(unsigned int add){
        
        spi_eeprom_ready();
        eeprom_cs=0;
        eeprom.write(0x02);
        eeprom.write(0xff&(add>>8));
        eeprom.write(0xff&add);
        
        for(int i=15; i<25; i++) {
            spi_eeprom_write( (int) VALVE_POS_VS_PWM[i]);
        }
        
        eeprom_cs=1;
}

void spi_eeprom_write_long_7(unsigned int add){
        
        spi_eeprom_ready();
        eeprom_cs=0;
        eeprom.write(0x02);
        eeprom.write(0xff&(add>>8));
        eeprom.write(0xff&add);
        
        for(int i=0; i<15; i++) {
            spi_eeprom_write((int) (JOINT_VEL[i] & 0xFFFFFFFF));
        }
        
        eeprom_cs=1;
}
        
void spi_eeprom_write_long_8(unsigned int add){
        
        spi_eeprom_ready();
        eeprom_cs=0;
        eeprom.write(0x02);
        eeprom.write(0xff&(add>>8));
        eeprom.write(0xff&add);
        
        for(int i=15; i<30; i++) {
            spi_eeprom_write((int) (JOINT_VEL[i] & 0xFFFFFFFF));
        }
        
        eeprom_cs=1;
}
void spi_eeprom_write_long_9(unsigned int add){
        
        spi_eeprom_ready();
        eeprom_cs=0;
        eeprom.write(0x02);
        eeprom.write(0xff&(add>>8));
        eeprom.write(0xff&add);
        
        for(int i=30; i<45; i++) {
            spi_eeprom_write((int) (JOINT_VEL[i] & 0xFFFFFFFF));
        }
        
        eeprom_cs=1;
}

void spi_eeprom_write_long_10(unsigned int add){
        
        spi_eeprom_ready();
        eeprom_cs=0;
        eeprom.write(0x02);
        eeprom.write(0xff&(add>>8));
        eeprom.write(0xff&add);
        
        for(int i=45; i<60; i++) {
            spi_eeprom_write((int) (JOINT_VEL[i] & 0xFFFFFFFF));
        }
        
        eeprom_cs=1;
}

void spi_eeprom_write_long_11(unsigned int add){
        
        spi_eeprom_ready();
        eeprom_cs=0;
        eeprom.write(0x02);
        eeprom.write(0xff&(add>>8));
        eeprom.write(0xff&add);
        
        for(int i=60; i<75; i++) {
            spi_eeprom_write((int) (JOINT_VEL[i] & 0xFFFFFFFF));
        }
        
        eeprom_cs=1;
}

void spi_eeprom_write_long_12(unsigned int add){
        
        spi_eeprom_ready();
        eeprom_cs=0;
        eeprom.write(0x02);
        eeprom.write(0xff&(add>>8));
        eeprom.write(0xff&add);
        
        for(int i=75; i<90; i++) {
            spi_eeprom_write((int) (JOINT_VEL[i] & 0xFFFFFFFF));
        }
        
        eeprom_cs=1;
}
        
void spi_eeprom_write_long_13(unsigned int add){
        
        spi_eeprom_ready();
        eeprom_cs=0;
        eeprom.write(0x02);
        eeprom.write(0xff&(add>>8));
        eeprom.write(0xff&add);
        
        for(int i=90; i<100; i++) {
            spi_eeprom_write((int) (JOINT_VEL[i] & 0xFFFFFFFF));
        }
        
        spi_eeprom_write((int) VALVE_MAX_POS);
        spi_eeprom_write((int) VALVE_MIN_POS);
        //writer.write(RID_DDV_CENTER, (int) (DDV_CENTER * 10.0f));
        spi_eeprom_write((int) VALVE_POS_NUM);
        spi_eeprom_write((int) K_SPRING);
        spi_eeprom_write((int) D_DAMPER);
        
        eeprom_cs=1;
}

unsigned int spi_eeprom_read(void){     
        int a1 = eeprom.write(0x00);
        int a2 = eeprom.write(0x00);
        int a3 = eeprom.write(0x00);
        int a4 = eeprom.write(0x00);
        unsigned int final = (a4<<24)+(a3<<16) + (a2<<8) + a1;
        return final;
} 

void spi_eeprom_read_long(void){
    spi_eeprom_read_long_1(0x0000);
    spi_eeprom_read_long_2(0x0100);
    spi_eeprom_read_long_3(0x0200);
    spi_eeprom_read_long_4(0x0300);
    spi_eeprom_read_long_5(0x0400);
    spi_eeprom_read_long_6(0x0500);
    spi_eeprom_read_long_7(0x0600);
    spi_eeprom_read_long_8(0x0700);
    spi_eeprom_read_long_9(0x0800);
    spi_eeprom_read_long_10(0x0900);
    spi_eeprom_read_long_11(0x1000);
    spi_eeprom_read_long_12(0x1100);
    spi_eeprom_read_long_13(0x1200);
}

void spi_eeprom_read_long_1(unsigned int add){
        eeprom_cs=0;
        eeprom.write(0x03);
        eeprom.write(0xff&((add)>>8));
        eeprom.write(0xff&(add));
        
        BNO = spi_eeprom_read();
        BNO = 1;
        OPERATING_MODE = spi_eeprom_read();
        SENSING_MODE = spi_eeprom_read();
        CURRENT_CONTROL_MODE = spi_eeprom_read();
        FLAG_VALVE_DEADZONE = spi_eeprom_read();
        CAN_FREQ = spi_eeprom_read();
        DIR_JOINT_ENC = spi_eeprom_read();
        DIR_VALVE = spi_eeprom_read();
        DIR_VALVE_ENC = spi_eeprom_read();
        SUPPLY_VOLTAGE = (float) (spi_eeprom_read()) *0.1f;
        VALVE_VOLTAGE_LIMIT = (float) (spi_eeprom_read()) * 0.1f;
        P_GAIN_VALVE_POSITION = spi_eeprom_read();
        I_GAIN_VALVE_POSITION = spi_eeprom_read();
        D_GAIN_VALVE_POSITION = spi_eeprom_read();
        P_GAIN_JOINT_POSITION = spi_eeprom_read();
        
        eeprom_cs=1;
}
       
void spi_eeprom_read_long_2(unsigned int add){
        eeprom_cs=0;
        eeprom.write(0x03);
        eeprom.write(0xff&((add)>>8));
        eeprom.write(0xff&(add));
        
        I_GAIN_JOINT_POSITION = spi_eeprom_read();
        D_GAIN_JOINT_POSITION = spi_eeprom_read();
        P_GAIN_JOINT_TORQUE = spi_eeprom_read();
        I_GAIN_JOINT_TORQUE = spi_eeprom_read();
        D_GAIN_JOINT_TORQUE = spi_eeprom_read();
        VALVE_DEADZONE_PLUS = (float) (spi_eeprom_read()) * 0.1f;
        VALVE_DEADZONE_MINUS = (float) (spi_eeprom_read()) * 0.1f;
        VELOCITY_COMP_GAIN = spi_eeprom_read();
        COMPLIANCE_GAIN = spi_eeprom_read();
        VALVE_CENTER = spi_eeprom_read();
        VALVE_FF = spi_eeprom_read();
        BULK_MODULUS = spi_eeprom_read();
        CHAMBER_VOLUME_A = spi_eeprom_read();
        CHAMBER_VOLUME_B = spi_eeprom_read();
        PISTON_AREA_A = spi_eeprom_read();
        
        eeprom_cs=1;
}
        
void spi_eeprom_read_long_3(unsigned int add){
        eeprom_cs=0;
        eeprom.write(0x03);
        eeprom.write(0xff&((add)>>8));
        eeprom.write(0xff&(add));
        
        PISTON_AREA_B = spi_eeprom_read();
        PISTON_AREA_alpha = (float)PISTON_AREA_B/(float)PISTON_AREA_A;
        alpha3 = PISTON_AREA_alpha * PISTON_AREA_alpha*PISTON_AREA_alpha;
        PRES_SUPPLY = spi_eeprom_read();
        PRES_RETURN = spi_eeprom_read();
        ENC_LIMIT_MINUS = spi_eeprom_read();
        ENC_LIMIT_PLUS = spi_eeprom_read();
        STROKE = spi_eeprom_read();
        //VALVE_LIMIT_MINUS = flashReadInt(Rom_Sector, RID_VALVE_LIMIT_MINUS);
        //VALVE_LIMIT_PLUS = flashReadInt(Rom_Sector, RID_VALVE_LIMIT_PLUS);
        ENC_PULSE_PER_POSITION = (float) (spi_eeprom_read()) * 0.1f;
    //    ENC_PULSE_PER_POSITION = (float) 1024.0f;
        TORQUE_SENSOR_PULSE_PER_TORQUE = (float) (spi_eeprom_read()) * 0.0001f;
        //TORQUE_SENSOR_PULSE_PER_TORQUE = (float) 0.41928f; //for ankle
    //    TORQUE_SENSOR_PULSE_PER_TORQUE = (float) 10000.0f/2048.0f; //for knee
        PRES_SENSOR_A_PULSE_PER_BAR = (float) (spi_eeprom_read()) * 0.01f;
    //    PRES_SENSOR_A_PULSE_PER_BAR = 4096.0f / 200.0f;
        PRES_SENSOR_B_PULSE_PER_BAR = (float) (spi_eeprom_read()) * 0.01f;
    //    PRES_SENSOR_B_PULSE_PER_BAR = 4096.0f / 200.0f;
        FRICTION = (float) (spi_eeprom_read()) * 0.1f;
        HOMEPOS_OFFSET = spi_eeprom_read();
        HOMEPOS_VALVE_OPENING = spi_eeprom_read();
        
        eeprom_cs=1;
}
       
void spi_eeprom_read_long_4(unsigned int add){
        eeprom_cs=0;
        eeprom.write(0x03);
        eeprom.write(0xff&((add)>>8));
        eeprom.write(0xff&(add));
        
        TORQUE_VREF = (float) (spi_eeprom_read()) *0.001f;
        PRES_A_VREF = (float) spi_eeprom_read() * 0.001f;
        PRES_B_VREF = (float) spi_eeprom_read() * 0.001f;
        VALVE_GAIN_LPM_PER_V[0] = (float) (spi_eeprom_read()) * 0.01f;
        VALVE_GAIN_LPM_PER_V[2] = (float) (spi_eeprom_read()) * 0.01f;
        VALVE_GAIN_LPM_PER_V[4] = (float) (spi_eeprom_read()) * 0.01f;
        VALVE_GAIN_LPM_PER_V[6] = (float) (spi_eeprom_read()) * 0.01f;
        VALVE_GAIN_LPM_PER_V[8] = (float) (spi_eeprom_read()) * 0.01f;
        VALVE_GAIN_LPM_PER_V[1] = (float) (spi_eeprom_read()) * 0.01f;
        VALVE_GAIN_LPM_PER_V[3] = (float) (spi_eeprom_read()) * 0.01f;
        VALVE_GAIN_LPM_PER_V[5] = (float) (spi_eeprom_read()) * 0.01f;
        VALVE_GAIN_LPM_PER_V[7] = (float) (spi_eeprom_read()) * 0.01f;
        VALVE_GAIN_LPM_PER_V[9] = (float) (spi_eeprom_read()) * 0.01f;
        
        eeprom_cs=1;
}

void spi_eeprom_read_long_5(unsigned int add){
        eeprom_cs=0;
        eeprom.write(0x03);
        eeprom.write(0xff&((add)>>8));
        eeprom.write(0xff&(add));
        
        for(int i=0; i<15; i++) {
            VALVE_POS_VS_PWM[i] = (float) (spi_eeprom_read());
        }

        eeprom_cs=1;
}

void spi_eeprom_read_long_6(unsigned int add){
        eeprom_cs=0;
        eeprom.write(0x03);
        eeprom.write(0xff&((add)>>8));
        eeprom.write(0xff&(add));

        for(int i=15; i<25; i++) {
            VALVE_POS_VS_PWM[i] = (float) (spi_eeprom_read());
        }

        eeprom_cs=1;
}

void spi_eeprom_read_long_7(unsigned int add){
        eeprom_cs=0;
        eeprom.write(0x03);
        eeprom.write(0xff&((add)>>8));
        eeprom.write(0xff&(add));
        
        for(int i=0; i<15; i++) {
            JOINT_VEL[i] = spi_eeprom_read() ;
        }

        eeprom_cs=1;
}

void spi_eeprom_read_long_8(unsigned int add){
        eeprom_cs=0;
        eeprom.write(0x03);
        eeprom.write(0xff&((add)>>8));
        eeprom.write(0xff&(add));
        
        for(int i=15; i<30; i++) {
            JOINT_VEL[i] = spi_eeprom_read() ;
        }

        eeprom_cs=1;
}

void spi_eeprom_read_long_9(unsigned int add){
        eeprom_cs=0;
        eeprom.write(0x03);
        eeprom.write(0xff&((add)>>8));
        eeprom.write(0xff&(add));
                
        for(int i=30; i<45; i++) {
            JOINT_VEL[i] = spi_eeprom_read() ;
        }

        eeprom_cs=1;
}

void spi_eeprom_read_long_10(unsigned int add){
        eeprom_cs=0;
        eeprom.write(0x03);
        eeprom.write(0xff&((add)>>8));
        eeprom.write(0xff&(add));

        for(int i=45; i<60; i++) {
            JOINT_VEL[i] = spi_eeprom_read() ;
        }

        eeprom_cs=1;
}

void spi_eeprom_read_long_11(unsigned int add){
        eeprom_cs=0;
        eeprom.write(0x03);
        eeprom.write(0xff&((add)>>8));
        eeprom.write(0xff&(add));
        
        for(int i=60; i<75; i++) {
            JOINT_VEL[i] = spi_eeprom_read() ;
        }

        eeprom_cs=1;
}

void spi_eeprom_read_long_12(unsigned int add){
        eeprom_cs=0;
        eeprom.write(0x03);
        eeprom.write(0xff&((add)>>8));
        eeprom.write(0xff&(add));

        for(int i=75; i<90; i++) {
            JOINT_VEL[i] = spi_eeprom_read() ;
        }
        
        eeprom_cs=1;
}
        
void spi_eeprom_read_long_13(unsigned int add){
        eeprom_cs=0;
        eeprom.write(0x03);
        eeprom.write(0xff&((add)>>8));
        eeprom.write(0xff&(add));
        
        for(int i=90; i<100; i++) {
            JOINT_VEL[i] = spi_eeprom_read() ;
        }
        
        VALVE_MAX_POS = spi_eeprom_read();
        VALVE_MIN_POS = spi_eeprom_read();
        //DDV_CENTER = (float) (flashReadInt(Rom_Sector, RID_DDV_CENTER)) * 0.1f;
        VALVE_POS_NUM = spi_eeprom_read();
        
        K_SPRING = spi_eeprom_read();
        D_DAMPER = spi_eeprom_read();
        
        eeprom_cs=1;
}