#include "mbed.h"
#include "FastPWM.h"

#define PIN_A PA_8 // channel 1
#define PIN_B PA_7 // complementary
#define PWM_ARR 0x8CA  /// timer autoreload value 40k loop, 40k pwm 

float dtc_a=0.1;
float dtc_b=0.2;
void Init_PWM();
DigitalOut check(PC_9);
DigitalIn a1(PB_7);
DigitalIn a2(PB_6);


extern "C" void TIM1_UP_TIM10_IRQHandler(void) {
  if (TIM1->SR & TIM_SR_UIF ) {
    check=1;
    TIM1->CCR1 = (PWM_ARR)*(1.0f-dtc_a);                        // Write duty cycles                                   
    check=0;
    }
TIM1->SR = 0x0;  // reset the status register
}


int main(){
    check=1;
    Init_PWM();
    TIM1->CR1 ^= TIM_CR1_UDIS;
    while(1);
}



void Init_PWM(){

    RCC->APB2ENR |= RCC_APB2ENR_TIM1EN;                         // enable TIM1 clock

    FastPWM pwm_a(PIN_A);                                       // 단순히 핀 설정용 
    FastPWM pwm_b(PIN_B);
    
     //ISR Setup     
    
    NVIC_EnableIRQ(TIM1_UP_TIM10_IRQn);                         //Enable TIM1 IRQ

    TIM1->DIER |= TIM_DIER_UIE;                                 // enable update interrupt
    TIM1->CR1 = 0x40;                                           // CMS = 10, interrupt only when counting up // Center-aligned mode
    TIM1->CR1 |= TIM_CR1_UDIS;
    TIM1->CR1 |= TIM_CR1_ARPE;                                  // autoreload on, 
    TIM1->RCR |= 0x001;                                         // update event once per up/down count of tim1 
    TIM1->EGR |= TIM_EGR_UG;


 
    //PWM Setup

    TIM1->PSC = 0x0;                                            // no prescaler, timer counts up in sync with the peripheral clock
    TIM1->ARR = PWM_ARR;                                          // set auto reload, 40 khz
//    TIM1->CCER |= ~(TIM_CCER_CC1NP);                            // Interupt when low side is on.
    TIM1->CR1 |= TIM_CR1_CEN;                                   // enable TIM1
    
    // for complementary 
    TIM1->CCER|=0b1111;
    }