#include "mbed.h"
#include "FastPWM.h"

#define PIN_U PA_10
#define PIN_V PA_9
#define PIN_W PA_8
#define PWM_ARR 0x8CA  /// timer autoreload value

float dtc_u=0.1;
float dtc_v=0.2;
float dtc_w=0.6;
void Init_PWM();

extern "C" void TIM1_UP_TIM10_IRQHandler(void) {
  if (TIM1->SR & TIM_SR_UIF ) {
    TIM1->CCR3 = (PWM_ARR)*(1.0f-dtc_u);                        // Write duty cycles
    TIM1->CCR2 = (PWM_ARR)*(1.0f-dtc_v);
    TIM1->CCR1 = (PWM_ARR)*(1.0f-dtc_w);                        // CCR1 = channel 1                                      
    }
TIM1->SR = 0x0;  // reset the status register
}


int main(){
    Init_PWM();
    TIM1->CR1 ^= TIM_CR1_UDIS;
    while(1);
}



void Init_PWM(){

    RCC->AHB1ENR |= RCC_AHB1ENR_GPIOCEN;                        // enable the clock to GPIOC
    RCC->APB1ENR |= 0x00000001;                                 // enable TIM2 clock
    RCC->APB2ENR |= RCC_APB2ENR_TIM1EN;                         // enable TIM1 clock

    GPIOC->MODER |= (1 << 10);                                  // set pin 5 to be general purpose output for LED
//    gpio->enable = new DigitalOut(ENABLE_PIN);
//    gpio->pwm_u = new FastPWM(PIN_U);
//    gpio->pwm_v = new FastPWM(PIN_V);
//    gpio->pwm_w = new FastPWM(PIN_W);
    FastPWM pwm_u(PIN_U);                                       // 단순히 핀 설정용 
    FastPWM pwm_v(PIN_V);
    FastPWM pwm_w(PIN_W);
    
     //ISR Setup     
    
    NVIC_EnableIRQ(TIM1_UP_TIM10_IRQn);                         //Enable TIM1 IRQ

    TIM1->DIER |= TIM_DIER_UIE;                                 // enable update interrupt
    TIM1->CR1 = 0x40;                                           // CMS = 10, interrupt only when counting up // Center-aligned mode
    TIM1->CR1 |= TIM_CR1_UDIS;
    TIM1->CR1 |= TIM_CR1_ARPE;                                  // autoreload on, 
    TIM1->RCR |= 0x001;                                         // update event once per up/down count of tim1 
    TIM1->EGR |= TIM_EGR_UG;
 
    //PWM Setup

    TIM1->PSC = 0x0;                                            // no prescaler, timer counts up in sync with the peripheral clock
    TIM1->ARR = PWM_ARR;                                          // set auto reload, 40 khz
    TIM1->CCER |= ~(TIM_CCER_CC1NP);                            // Interupt when low side is on.
    TIM1->CR1 |= TIM_CR1_CEN;                                   // enable TIM1
    
    }