#include "mbed.h"
#include "FastPWM.h"
#include "INIT_HW.h"
#include "SPI_EEP_ENC.h"
#include "I2C_AS5510.h"
#include "setting.h"

// dac & check
DigitalOut check(PC_2);
DigitalOut check_2(PC_3);
AnalogOut dac_1(PA_4);
AnalogOut dac_2(PA_5);
DigitalIn a(PB_7);
DigitalIn b(PB_6);
DigitalIn c(PA_6);
DigitalIn d(PC_9);

// pwm
float dtc=0;

// I2C
I2C i2c(PB_3,PB_10); // SDA, SCL (for K22F)
const int i2c_slave_addr1 =  0x56;
unsigned int value; // 10bit output of reading sensor AS5510

// SPI
SPI eeprom(PB_15, PB_14, PB_13); // EEPROM //(SPI_MOSI, SPI_MISO, SPI_SCK);
DigitalOut eeprom_cs(PB_12);
SPI enc(PC_12,PC_11,PC_10);
DigitalOut enc_cs(PD_2);

// UART
Serial pc(PA_9,PA_10); //  _ UART

//CAN
CAN can(PB_8, PB_9, 1000000);
CANMessage msg;
void onMsgReceived()
{
    can.read(msg);
    pc.printf("Message received: %d\n", msg.data[0]);
}


Timer t;
//t.start();
//t.stop();
//pc.printf("The time taken was %f seconds\n",t.read());
int a1;
int i=0;
float y;

extern "C" void TIM1_UP_TIM10_IRQHandler(void)
{
    if (TIM1->SR & TIM_SR_UIF ) {
//        y=0.05*sin(i*0.00001);
//        y= 0.1;
//        if (i>10000){i=0;}
//        y=0.01*i/100000;
        y=-0.04683;
        //
//        dtc_w = 0.1;
//        dtc_v = 1;
        //
        
        //PIN_V dir
        dtc=0.5;
        i++;
        //ADC
        ADC1->CR2  |= 0x40000000;                        // adc _ 12bit
//      a1=ADC1->DR;
//    a1=ADC2->DR;
        a1=ADC3->DR;

//    //pwm
        TIM1->CCR1 = (PWM_ARR)*(1.0f-dtc);
//    check = 0;
    }
    TIM1->SR = 0x0;  // reset the status register
}



int main()
{

    // ADC init
    Init_ADC();
    // Pwm init
    Init_PWM();
    TIM1->CR1 ^= TIM_CR1_UDIS;
    // CAN
    can.attach(&onMsgReceived);
    while(1) {
        pc.printf("%d\n",a1);
//        msg.data[0]=0xFF&a1;
//        msg.data[1]=0xFF&(a1>>8);
//        can.write(msg);
        check_2=0;
//        wait(0.00005f);
    }
}