#include "mbed.h"
#include "FastPWM.h"
#include "INIT_HW.h"
#include "SPI_EEP_ENC.h"
#include "I2C_AS5510.h"
#include "setting.h"

// dac & check
DigitalOut check(PC_2);
DigitalOut check_2(PC_3);
AnalogOut dac_1(PA_4);
AnalogOut dac_2(PA_5);

// pwm
float dtc_v=0;
float dtc_w=0;

// I2C
I2C i2c(PC_9,PA_8); // SDA, SCL (for K22F)
const int i2c_slave_addr1 =  0x56;
unsigned int value; // 10bit output of reading sensor AS5510

// SPI
SPI eeprom(PB_15, PB_14, PB_13); // EEPROM //(SPI_MOSI, SPI_MISO, SPI_SCK);
DigitalOut eeprom_cs(PB_12);
SPI enc(PC_12,PC_11,PC_10);
DigitalOut enc_cs(PD_2);

// UART
Serial pc(PA_9,PA_10); //  _ UART

//CAN
CAN can(PB_8, PB_9, 1000000);
CANMessage msg;
void onMsgReceived()
{
    can.read(msg);
    pc.printf("Message received: %d\n", msg.data[0]);
}


Timer t;
//t.start();
//t.stop();
//pc.printf("The time taken was %f seconds\n",t.read());
int a1;
int i=0;
float y;

extern "C" void TIM4_IRQHandler(void)
{
    if (TIM4->SR & TIM_SR_UIF ) {
//        y=0.05*sin(i*0.00001);
//        y= 0.1;
//        if (i>10000){i=0;}
//        y=0.01*i/100000;
        y=-0.04683;
        //
//        dtc_w = 0.1;
//        dtc_v = 1;
        //
        
        //PIN_V dir
        
        if (y>0) {
            dtc_v=0;
            dtc_w=y;
        } else {
            dtc_v=0;
            dtc_w=-y;
        }
        i++;
//    check = 1;
//    //spi
//    eeprom.write(0xff);
//    eeprom.write(0xff);
////    ready();
////    read(1);
//    //i2c
////    read_field(i2c_slave_addr1);
        //ADC
        ADC1->CR2  |= 0x40000000;                        // adc _ 12bit
//      a1=ADC1->DR;
//    a1=ADC2->DR;
        a1=ADC3->DR;
//    //계산
//    //
//    //
//
//    //DAC
//    dac_1 = ADC1->DR;
//    dac_2 = ADC2->DR;
//    //pwm
        TIM4->CCR2 = (PWM_ARR)*(1.0f-dtc_v);
        TIM4->CCR1 = (PWM_ARR)*(1.0f-dtc_w);
//    check = 0;
    }
    TIM4->SR = 0x0;  // reset the status register
}



int main()
{

    // i2c init
//    i2c.frequency(400 * 1000);          // 0.4 mHz
//    wait_ms(2);                         // Power Up wait
//    look_for_hardware_i2c();            // Hardware present
//    init_as5510(i2c_slave_addr1);
//    // spi init
    eeprom.format(8,3);
    eeprom.frequency(5000000); //5M
    enc.format(8,0);
    enc.frequency(5000000); //5M
    // ADC init
    Init_ADC();
    // Pwm init
    Init_PWM();
    TIM4->CR1 ^= TIM_CR1_UDIS;
//    //SPI
//    spi_eeprom_ready();
//    spi_eeprom_write(0x1,0x112);
//    spi_eeprom_ready();
//    int i = spi_eeprom_read(0x1);
    // CAN
    can.attach(&onMsgReceived);
    // spi _ enc
    spi_enc_set_init();
    msg.len=2;
    while(1) {
//        dac_1=0.5;
//        dac_2=0.1;
        check_2 = 1;
        //spi _ eeprom
//        spi_eeprom_ready();
//        spi_eeprom_write(0x0001,0xFFFFFFFF);
//        spi_eeprom_ready();
//        int a=spi_eeprom_read(0x0001);
        //spi _ enc
        int a = spi_enc_read();
//        read_field(i2c_slave_addr1);
        pc.printf("%d\n",a1);
//        msg.data[0]=0xFF&a1;
//        msg.data[1]=0xFF&(a1>>8);
//        can.write(msg);
        check_2=0;
//        wait(0.00005f);
    }
}