#include "mbed.h"
#include "setting.h"
#include "SPI_EEP_ENC.h"

// EEPROM
void spi_eeprom_ready(void){
    int temp1, temp2;
    do{
        eeprom_cs=0;
        eeprom.write(0x06);  //write enable
        eeprom_cs=1;
        
        eeprom_cs=0;
        temp1 = eeprom.write(0x05);     
        temp2 = eeprom.write(0x00);
        eeprom_cs=1;
        temp2=(temp2&(0x03))!= 0x02;
    } while(temp2); // before writing or reading 
}
// 
 void spi_eeprom_write(unsigned short add, unsigned int data){
        spi_eeprom_ready();
        add=add*4;
        eeprom_cs=0;
        eeprom.write(0x02);
        eeprom.write(0xff&(add>>8));
        eeprom.write(0xff&add);
        eeprom.write(0xff&data);
        eeprom.write(0xff&(data>>8));
        eeprom.write(0xff&(data>>16));
        eeprom.write(0xff&(data>>24));
        eeprom_cs=1;
}
// 
unsigned int spi_eeprom_read(unsigned short add){
        add=add*4;
        eeprom_cs=0;
        eeprom.write(0x03);
        eeprom.write(0xff&(add>>8));
        eeprom.write(0xff&add);
//        
        int a1 = eeprom.write(0x00);
        int a2 = eeprom.write(0x00);
        int a3 = eeprom.write(0x00);
        int a4 = eeprom.write(0x00);
        eeprom_cs=1;
        //unsigned int final = (a4<<24)+(a3<<16) + (a2<<8) + a1;
        unsigned int final = (int32_t) (a1 | a2 << 8 | a3 << 16 | a4 << 24);
        return final;
} 

void spi_eeprom_call_data(void)
{
    BNO = spi_eeprom_read(RID_BNO);
    BNO = 11;
    OPERATING_MODE = spi_eeprom_read(RID_OPERATING_MODE);
    SENSING_MODE = spi_eeprom_read(RID_SENSING_MODE);
    SENSING_MODE = 1;
    CURRENT_CONTROL_MODE = spi_eeprom_read(RID_CURRENT_CONTROL_MODE);
    CURRENT_CONTROL_MODE = 1;
    FLAG_VALVE_DEADZONE = spi_eeprom_read(RID_FLAG_VALVE_DEADZONE);
    CAN_FREQ = spi_eeprom_read(RID_CAN_FREQ);
    CAN_FREQ = 500;
    DIR_JOINT_ENC = spi_eeprom_read(RID_JOINT_ENC_DIR);
    DIR_VALVE = spi_eeprom_read(RID_VALVE_DIR);
    DIR_VALVE_ENC = spi_eeprom_read(RID_VALVE_ENC_DIR);
    SUPPLY_VOLTAGE = (float) (spi_eeprom_read(RID_VOLATGE_SUPPLY)) *0.1f;
    VALVE_VOLTAGE_LIMIT = (float) (spi_eeprom_read(RID_VOLTAGE_VALVE)) * 0.1f;
    P_GAIN_VALVE_POSITION = spi_eeprom_read(RID_P_GAIN_VALVE_POSITION);
    I_GAIN_VALVE_POSITION = spi_eeprom_read(RID_I_GAIN_VALVE_POSITION);
    D_GAIN_VALVE_POSITION = spi_eeprom_read(RID_D_GAIN_VALVE_POSITION);
    P_GAIN_JOINT_POSITION = spi_eeprom_read(RID_P_GAIN_JOINT_POSITION);
    I_GAIN_JOINT_POSITION = spi_eeprom_read(RID_I_GAIN_JOINT_POSITION);
    D_GAIN_JOINT_POSITION = spi_eeprom_read(RID_D_GAIN_JOINT_POSITION);
    P_GAIN_JOINT_TORQUE = spi_eeprom_read(RID_P_GAIN_JOINT_TORQUE);
    I_GAIN_JOINT_TORQUE = spi_eeprom_read( RID_I_GAIN_JOINT_TORQUE);
    D_GAIN_JOINT_TORQUE = spi_eeprom_read(RID_D_GAIN_JOINT_TORQUE);
    VALVE_DEADZONE_PLUS = (float) (spi_eeprom_read( RID_VALVE_DEADZONE_PLUS)) * 0.1f;
    VALVE_DEADZONE_MINUS = (float) (spi_eeprom_read(RID_VALVE_DEADZONE_MINUS)) * 0.1f;
    VELOCITY_COMP_GAIN = spi_eeprom_read(RID_VELOCITY_COMP_GAIN);
    COMPLIANCE_GAIN = spi_eeprom_read(RID_COMPLIANCE_GAIN);
    VALVE_CENTER = spi_eeprom_read(RID_VALVE_CNETER);
    VALVE_FF = spi_eeprom_read(RID_VALVE_FF);
    BULK_MODULUS = spi_eeprom_read(RID_BULK_MODULUS);
    CHAMBER_VOLUME_A = spi_eeprom_read(RID_CHAMBER_VOLUME_A);
    CHAMBER_VOLUME_B = spi_eeprom_read(RID_CHAMBER_VOLUME_B);
    PISTON_AREA_A = spi_eeprom_read(RID_PISTON_AREA_A);
    PISTON_AREA_B = spi_eeprom_read(RID_PISTON_AREA_B);
    PISTON_AREA_alpha = (float)PISTON_AREA_A/(float)PISTON_AREA_B;
    alpha3 = PISTON_AREA_alpha * PISTON_AREA_alpha*PISTON_AREA_alpha;
    PRES_SUPPLY = spi_eeprom_read(RID_PRES_SUPPLY);
    PRES_RETURN = spi_eeprom_read(RID_PRES_RETURN);
    ENC_LIMIT_MINUS = spi_eeprom_read(RID_ENC_LIMIT_MINUS);
    ENC_LIMIT_PLUS = spi_eeprom_read(RID_ENC_LIMIT_PLUS);
    STROKE = spi_eeprom_read(RID_STROKE);
    //VALVE_LIMIT_MINUS = flashReadInt(Rom_Sector, RID_VALVE_LIMIT_MINUS);
    //VALVE_LIMIT_PLUS = flashReadInt(Rom_Sector, RID_VALVE_LIMIT_PLUS);
    ENC_PULSE_PER_POSITION = (float) (spi_eeprom_read(RID_ENC_PULSE_PER_POSITION)) * 0.1f;
//    ENC_PULSE_PER_POSITION = (float) 1024.0f;
    TORQUE_SENSOR_PULSE_PER_TORQUE = (float) (spi_eeprom_read(RID_TORQUE_SENSOR_PULSE_PER_TORQUE)) * 0.0001f;
    //TORQUE_SENSOR_PULSE_PER_TORQUE = (float) 0.41928f; //for ankle
//    TORQUE_SENSOR_PULSE_PER_TORQUE = (float) 10000.0f/2048.0f; //for knee
    PRES_SENSOR_A_PULSE_PER_BAR = (float) (spi_eeprom_read(RID_PRES_SENSOR_A_PULSE_PER_BAR)) * 0.01f;
    PRES_SENSOR_A_PULSE_PER_BAR = 4096.0f * 946.0f / 3.3f / 300.0f / 210.0f;
    PRES_SENSOR_B_PULSE_PER_BAR = (float) (spi_eeprom_read(RID_PRES_SENSOR_B_PULSE_PER_BAR)) * 0.01f;
    PRES_SENSOR_B_PULSE_PER_BAR = 4096.0f * 946.0f / 3.3f / 300.0f / 210.0f;
    FRICTION = (float) (spi_eeprom_read(RID_FRICTION)) * 0.1f;
    HOMEPOS_OFFSET = spi_eeprom_read(RID_HOMEPOS_OFFSET);
    HOMEPOS_VALVE_OPENING = spi_eeprom_read(RID_HOMEPOS_VALVE_OPENING);
    TORQUE_VREF = (float) (spi_eeprom_read(RID_TORQUE_SENSOR_VREF)) *0.001f;
    PRES_A_VREF = (float) spi_eeprom_read(RID_PRES_A_SENSOR_VREF) * 0.001f;
    PRES_B_VREF = (float) spi_eeprom_read(RID_PRES_B_SENSOR_VREF) * 0.001f;
    VALVE_GAIN_LPM_PER_V[0] = (float) (spi_eeprom_read(RID_VALVE_GAIN_PLUS_1)) * 0.01f;
    VALVE_GAIN_LPM_PER_V[2] = (float) (spi_eeprom_read(RID_VALVE_GAIN_PLUS_2)) * 0.01f;
    VALVE_GAIN_LPM_PER_V[4] = (float) (spi_eeprom_read(RID_VALVE_GAIN_PLUS_3)) * 0.01f;
    VALVE_GAIN_LPM_PER_V[6] = (float) (spi_eeprom_read(RID_VALVE_GAIN_PLUS_4)) * 0.01f;
    VALVE_GAIN_LPM_PER_V[8] = (float) (spi_eeprom_read(RID_VALVE_GAIN_PLUS_5)) * 0.01f;
    VALVE_GAIN_LPM_PER_V[1] = (float) (spi_eeprom_read(RID_VALVE_GAIN_MINUS_1)) * 0.01f;
    VALVE_GAIN_LPM_PER_V[3] = (float) (spi_eeprom_read(RID_VALVE_GAIN_MINUS_2)) * 0.01f;
    VALVE_GAIN_LPM_PER_V[5] = (float) (spi_eeprom_read(RID_VALVE_GAIN_MINUS_3)) * 0.01f;
    VALVE_GAIN_LPM_PER_V[7] = (float) (spi_eeprom_read(RID_VALVE_GAIN_MINUS_4)) * 0.01f;
    VALVE_GAIN_LPM_PER_V[9] = (float) (spi_eeprom_read(RID_VALVE_GAIN_MINUS_5)) * 0.01f;
    for(int i=0; i<25; i++) {
        VALVE_POS_VS_PWM[i] = (float) (spi_eeprom_read(RID_VALVE_POS_VS_PWM_0 + i));
    }
    for(int i=0; i<100; i++) {
        JOINT_VEL[i] = ( ((spi_eeprom_read( RID_VALVE_POS_VS_FLOWRATE_0 + i)) & 0xFFFF) | ((spi_eeprom_read(RID_VALVE_POS_VS_FLOWRATE_0_1 + i)) & 0xFFFF) << 16 ) ;
    }
    VALVE_MAX_POS = spi_eeprom_read(RID_VALVE_MAX_POS);
    VALVE_MIN_POS = spi_eeprom_read(RID_VALVE_MIN_POS);
    //DDV_CENTER = (float) (flashReadInt(Rom_Sector, RID_DDV_CENTER)) * 0.1f;
    VALVE_POS_NUM = spi_eeprom_read(RID_VALVE_POS_NUM);
    
    K_SPRING = spi_eeprom_read(RID_K_SPRING);
    D_DAMPER = spi_eeprom_read(RID_D_DAMPER);

    
}
 
 // ENCODER
void spi_enc_set_clear(void){
    unsigned int temp;
    enc_cs = 0;
    temp = enc.write(0b00100000);
    enc_cs = 1;
}

void spi_enc_set_init(void){
    unsigned int temp, i, temp1, temp2;

    // write MDR0 -> 0b11 -> x4 quadrature count mode
    enc_cs = 0;
    temp = enc.write(0b10001000);     // WR + MDR0
    temp = enc.write(0b00000011);     // quadratue mode
    enc_cs = 1;

    // write MDR1 -> 0b10 -> 2-byte counter mode
    for(i=0;i<100;i++);
    enc_cs = 0;
    temp = enc.write(0b10010000);     // WR + MDR1
    //temp = enc.write(0b00000010);     // 2 byte mode
    temp = enc.write(0b00000000);     // 4 byte mode
    enc_cs = 1;
    
    // clear
    spi_enc_set_clear();
}


int spi_enc_read(void){   
    //for(t_i=0;t_i<100;t_i++);
    unsigned int t_dummy, t_b1, t_b2, t_b3, t_b4, t_i;
    enc_cs = 0;
    t_dummy = enc.write(0b01100000); // Read Commend 
    t_b1 = enc.write(0x00);         // Dummy data for clock
    t_b2 = enc.write(0x00);         // Dummy data for clock
    t_b3 = enc.write(0x00);         // Dummy data for clock
    t_b4 = enc.write(0x00);         // Dummy data for clock
    enc_cs = 1;

    return((t_b1<<24) + (t_b2<<16) + (t_b3<<8) + t_b4);
}