//##############################################################
//##
//## Event: RoboVal - Robot Race
//##
//## Chronometer double use
//##
//## Version 1.99A
//##
//## Hardware platform used: ST NUCLEO-F401RE
//##
//## Software IDE used: mbed online version
//##
//## Organizzation: Verona FabLab
//##
//## Date creation: 2018.01.01
//##
//## Software developpers: FdF,GV, AG
//##
//## Base on original version of by FdF
//##
//##############################################################

#include <stdlib.h>
#include "mbed.h"
#include "TextLCD.h"
#include "Hotboards_keypad.h"
 
 
// Default Number Lap
#define NUM_LAP 3

// Reference for Low/Min Voltage battery
#define VBAT_MIN 7.2
 
// Defines the keys array with it's respective number of rows & cols,
// and with the value of each key
char keys[ 4 ][ 4 ] =
{
    { '1' , '2' , '3' , 'A' },
    { '4' , '5' , '6' , 'B' },
    { '7' , '8' , '9' , 'C' },
    { '*' , '0' , '#' , 'D' }
};
 
// Pin keypad 4x4
//  1,    2,     3,    4,     5,    6,    7,    8
//  C4,   C3,    C2,   C1,    R4,   R3,   R2,   R1
// PB_0, PA_4 , PA_1 , PA_0, PA_13, PA_14, PC_14, PC_15
// PC_15, PC_14, PA_14, PA_13, PA_0, PA_1, PA_4, PB_0
// 
// Defines the pins connected to the rows
DigitalInOut rowPins[ 4 ] = { PB_0 , PA_4 , PA_1 , PA_0 };

// Defines the pins connected to the cols
DigitalInOut colPins[ 4 ] = { PB_0 , PA_4 , PA_1 , PA_0  };
 
// Creates a new keyboard with the values entered before
Keypad kpd( makeKeymap( keys ) , rowPins , colPins , 4 , 4 );
 
// Configures the serial port
Serial pc( USBTX , USBRX );
 


 // read Voltage battery
DigitalOut heartbeat(LED1);

// read Voltage battery, analog pin used PC_3 (Pin 37 of Morpho layout)
//AnalogIn vbat(PC_3);
 
// User button pressure 
InterruptIn user_button(USER_BUTTON); 

// Sensor connected to digital input D9, alias PC7 on Morpho layout
// Now p29 and p31
InterruptIn proximity(D9); 


// LCD Display (RS, E, D4, D5, D6, D7);
TextLCD lcd(D2,D3,D4,D5,D6,D7); 
 

 
 
//------------------------------------------------------------ 
//
//       Main body
//
//------------------------------------------------------------
 
int main() {
    
    proximity.mode(PullDown);
  
    
    while(true) {       
        
        lcd.locate(0,0);
        lcd.printf("Character: ");
        
        heartbeat = !heartbeat;
                
        // Poll the keypad to look for any activation
        char key = kpd.getKey( );
        
        // If any key was pressed
        if( key )
        {
            // Display the key pressed on serial port
            lcd.locate(0,1);            
            lcd.printf( "%c" , key );
            //lcd.printf( "\n\r" );
        }
    }
}

