#include "mbed.h"
#include "HIDScope.h"
#include "encoder.h"

//hidscope met gewenst aantal kanalen
HIDScope scope(2);

//analoog in van potmeter 1
AnalogIn pot1(A0);

//signaal naar motor uit
DigitalOut motor1_direction(D7);// draairichting motor 1 (1 is CW )
PwmOut motor1_speed_control(D6);//aanstuursnelheid motor 1
//PwmOut motor2_speed_control(D5);
//DigitalOut motor2_direction(D4);

//encoders
Encoder motor1_encoder(D13,D12);
//Encoder motor2_encoder(D11,D10);

//tickers
Ticker scopedataticker;
Ticker adjust_positionticker;

//frequenties
const float motor_frequency_pwm = 1000; //1kHz PWM
const float scopedatafrequency=50;// frequentie waarmee informatie naar de scope gestuurd wordt
const float adjust_position_frequency=8; // frequentie waarmee de motorpositie aangepast wordt

//constanten
const float cpr=4200;


//go flags
bool scopedata_go=false;
bool adjust_position_go=false;

//activators
void scopedata_activate()
{
    scopedata_go=true;
}
void adjust_position_activate()
{
    adjust_position_go=true;
}

//scopefunctie
void scopedata()
{
    scope.set(0,pot1.read());
    scope.set(1,motor1_encoder.getPosition());
    scope.send();
}

//adjust position
void adjust_position()
{
    float wantedposition=cpr*(pot1.read());
    int actualposition=(motor1_encoder.getPosition());
    if (wantedposition<=actualposition) {
        motor1_direction=0;
        motor1_speed_control=0.5;
    } else if (wantedposition>=actualposition) {
        motor1_direction=1;
        motor1_speed_control=0.5;
    } else {
        motor1_direction=1;
        motor1_speed_control=0;
    }
}

int main ()
{
    motor1_speed_control.period(1/motor_frequency_pwm);

    scopedataticker.attach(&scopedata_activate,1/scopedatafrequency);
    adjust_positionticker.attach(&adjust_position_activate,1/adjust_position_frequency);

    while(1) {
        if (scopedata_go==true) {
            scopedata();
            scopedata_go=false;
        }
        if (adjust_position_go==true) {
            adjust_position();
            adjust_position_go=false;

        }
    }
}
