#include "mbed.h"
#include "HIDScope.h"
#include "encoder.h"

//hidscope
HIDScope scope(2);

//potmeter in
AnalogIn pot1(A0);

//tickers
Ticker scopetimer;
Ticker potread;

//filter coefficients from asn filter designer
//Biquad #1
const double gain_f1=0.049174;
const double B_f1[] = { 1.00000000000,  1.00000000000,  0.00000000000};
const double A_f1[] = { 1.00000000000, -0.90165118786,  0.00000000000};

//Biquad #2
const double gain_f2 = 0.109068;
const double B_f2[] = { 1.00000000000, -1.81192934459,  1.00000000000};
const double A_f2[] = { 1.00000000000, -1.89186536594,  0.91237793985};

//filterwaardes uit asn
double v1 = 0, v2 = 0, u = 0, y = 0;
const double a1_f1 = gain_f1*A_f1[1], a2_f1 = gain_f1*A_f1[2], b0_f1 = gain_f1*B_f1[0], b1_f1 = gain_f1*B_f1[1], b2_f1 = gain_f1*B_f1[2]; //filter coefficients filter 1
const double a1_f2 = gain_f2*A_f1[1], a2_f2 = gain_f2*A_f2[2], b0_f2 = gain_f2*B_f2[0], b1_f2 = gain_f2*B_f2[1], b2_f2 = gain_f2*B_f2[2]; //filter coefficients filter 1


//biquad filter
// Biquad filter (See slide 14)
double biquad( double u, double &v1, double &v2, const double a1, const double a2,
        const double b0, const double b1, const double b2 ){
    double v = u - a1*v1 - a2*v2;
    double y = b0*v + b1*v1 + b2*v2;
    v2 = v1; v1 = v;
    return y;
}
