/**
 * @author Jasper Gerth
 *
 * 
 * @section DESCRIPTION
 *
 * This library contains a P-, PI-, and a PID-controller.
 * The controller takes controller constants and the error and drives the motors.
 */

#ifndef _CONTROLANDADJUST_H_
#define _CONTROLANDADJUST_H_
/**
 * Includes
 */
#include "mbed.h"

/**
 * Controller for biorobotics
 */
class controlandadjust
{
    
public:

    /**
     * Constructor.
     *
     *Constructs a controller no don't put () after your controller
     *@param errorband : float Width of the band at of allowable error
     *@param controlfrequency : double Frequency of the controller in Hz
     */
    controlandadjust(float errorband, double controlfrequency);
    
    /** P controller
    * @param error1 : double Error from motor 1
    * @param error2 : double Error from motor 2
    * @param Kp : float Desired value of Kp for your controller
    * @return void
    */
    void P(double error1, double error2 ,float Kp );

    /** PI controller
    * @param error1 : double Error from motor 1
    * @param error2 : double Error from motor 2
    * @param Kp : float Desired value of Kp for your controller
    * @param Ki : float Desired value of Ki for your controller
    * @return void
    */
    void PI(double error1, double error2, float Kp, float Ki);

    /** PID controller
    * @param error1 : double Error from motor 1
    * @param error2 : double Error from motor 2
    * @param Kp : float Desired value of Kp for your controller
    * @param Ki : float Desired value of Ki for your controller
    * @param Kd : float Desired value of Kd for your controller
    * @return void
    */
    void PID(double error1, double error2, float Kp, float Ki, float Kd );
             
    /** Read the PWM signal to motor 1
    * @return PWM signal to motor 1
    */
    float motor1pwm();

    /** Read the PWM signal to motor 2
      * @return PWM signal to motor 2
      */
    float motor2pwm();
    
    /** STOPS both motors
    * @return void
    */
    void STOP();
    
     /** set safety cutoff value for the pwm signal to the motors
    * @return void
    */
    void cutoff(float maxvalue);

private:
    /**
     *Checks the signal and updates the PWM and direction for motor 1 and 2
     */
    void process_signal(double , double );

};

#endif /* CONTROLANDADJUST_H */