#include "controlandadjust.h"
#include "mbed.h"
#include "QEI.h"
//constants
int CW=1;
int CCW=0;
int direction1,direction2;
double speed1,speed2;
double signal1,signal2;
double error1_int,error2_int;
double error1_prev,error2_prev;

float maxvaluepwm=0;
float minimal_error;
double Ts;
const double pi=3.14159265359;
const double degtorad=(pi/180);

//Outputs
DigitalOut motor1_dir(D7);// rotation directoin motor 1, (1 is CW when looking to the top of the encoder(or shaft))
PwmOut motor1_speed(D6);//speed motor 1
PwmOut motor2_speed(D5);
DigitalOut motor2_dir(D4);

//constuctor
controlandadjust::controlandadjust(float errorband, double controlfrequency)
{
    minimal_error=errorband*degtorad/2;
    Ts=1.0/controlfrequency;
}

//take signal and write the rigth values to motors
void controlandadjust::process_signal(double signal1,double signal2)
{
    //motor1
    if (signal1>=0) {//determine CW or CCW rotation
        direction1=CCW;
    } else {
        direction1=CW;
    }

    if (fabs(signal1)>=maxvaluepwm) { //check if signal is <1
        speed1=maxvaluepwm;//if signal >1 make it 1 to not damage motor
    } else {
        speed1=fabs(signal1);// if signal<1 use signal
    }

    //motor2
    if (signal2>=0) {//determine CW or CCW rotation
        direction2=CW;
    } else {
        direction2=CCW;
    }

    if (fabs(signal2)>=maxvaluepwm) { //check if signal is <1
        speed2=maxvaluepwm;//if signal >1 make it 1 to not damage motor
    } else {
        speed2=fabs(signal2);// if signal<1 use signal
    }
    //write to motor
    motor1_dir.write(direction1);
    motor1_speed.write(speed1);
    motor2_dir.write(direction2);
    motor2_speed.write(speed2);

}
float controlandadjust::motor1pwm()
{
    return speed1;
}

float controlandadjust::motor2pwm()
{
    return speed2;
}


void controlandadjust::P(double error1,double error2,float Kp)
{
    signal1=error1*Kp;
    signal2=error2*Kp;

    //check if error is big enough to produce signal, else signal is 0 to save motors
    if (fabs(error1) > minimal_error && fabs(error2) > minimal_error) {
        process_signal(signal1,signal2);
    } else if (fabs(error1) <= minimal_error && fabs(error2) <= minimal_error) {
        process_signal(0,0);
    } else if (fabs(error1) > minimal_error && fabs(error2) <= minimal_error) {
        process_signal(signal1,0);
    } else if (fabs(error1) <= minimal_error && fabs(error2) > minimal_error) {
        process_signal(0,signal2);
    }
}

void controlandadjust::PI(double error1, double error2, float Kp, float Ki)
{
    error1_int = error1_int + Ts * error1;
    signal1=Kp*error1+Ki*error1_int;

    error2_int = error2_int + Ts * error2;
    signal2=Kp*error2+Ki*error2_int;

    //check if error is big enough to produce signal, else signal is 0 to save motors
    //and make error_int 0 if the error is small enough to protect from "spooling up"
    if (fabs(error1) > minimal_error && fabs(error2) > minimal_error) {
        process_signal(signal1,signal2);
    } else if (fabs(error1) <= minimal_error && fabs(error2) <= minimal_error) {
        process_signal(0,0);
        error1_int=0,error2_int=0;
    } else if (fabs(error1) > minimal_error && fabs(error2) <= minimal_error) {
        process_signal(signal1,0);
        error2_int=0;
    } else if (fabs(error1) <= minimal_error && fabs(error2) > minimal_error) {
        process_signal(0,signal2);
        error1_int=0;
    }
}

void controlandadjust::PID(double error1, double error2, float Kp, float Ki,float Kd)
{
    // Derivative
    double error1_der = (error1 - error1_prev)/Ts;
    error1_prev = error1;

    double error2_der = (error2 - error2_prev)/Ts;
    error2_prev = error2;

// Integral
    error1_int = error1_int + Ts * error1;
    error2_int = error2_int + Ts * error2;
// PID
    signal1= Kp * error1 + Ki * error1_int + Kd * error1_der;
    signal2= Kp * error2 + Ki * error2_int + Kd * error2_der;

    //check if error is big enough to produce signal, else signal is 0 to save motors
    //and make error_int 0 if the error is small enough to protect from "spooling up"
    if (fabs(error1) > minimal_error && fabs(error2) > minimal_error) {
        process_signal(signal1,signal2);
    } else if (fabs(error1) <= minimal_error && fabs(error2) <= minimal_error) {
        process_signal(0,0);
        error1_int=0,error2_int=0;
    } else if (fabs(error1) > minimal_error && fabs(error2) <= minimal_error) {
        process_signal(signal1,0);
        error2_int=0;
    } else if (fabs(error1) <= minimal_error && fabs(error2) > minimal_error) {
        process_signal(0,signal2);
        error1_int=0;
    }
}


void controlandadjust::STOP()
{
    motor1_speed.write(0);
    motor2_speed.write(0);
}
void controlandadjust::cutoff(float maxvalue)
{
    maxvaluepwm=maxvalue;
}