//////////////////////////////////////
// Based on PwmIn Library
// The basis is to disable the interrupts
// of the other PwmIn inputs
// Connected to the function generator
// puls on both inputs at the exact
// same time.
// Works excellent but further testing
// showed that there is no real advantage 
// above the original PmwIn library
//////////////////////////////////////
#include "mbed.h"
#include "InterruptIn.h"
#define NR 20

class PwmIn
{
public:
    PwmIn(PinName p);
    float period();
    float pulsewidth();
    float dutycycle();
    void disable();
    void enable();

protected:
    void rise();
    void fall();

    InterruptIn _p;
    Timer _t;
    volatile float _pulsewidth, _period;
};

PwmIn::PwmIn(PinName p) : _p(p)
{
    _p.rise(this, &PwmIn::rise);
    _p.fall(this, &PwmIn::fall);
    _period = 0.0;
    _pulsewidth = 0.0;
    _t.start();
}

PwmIn a(PTD2);  // Sensor 1 X direction
PwmIn b(PTA17); // Sensor 1 Y direction
Serial pc(USBTX, USBRX); // tx, rx

float PwmIn::period()
{
    return _period;
}

float PwmIn::pulsewidth()
{
    return _pulsewidth;
}

float PwmIn::dutycycle()
{
    return _pulsewidth / _period;
}

void PwmIn::disable()
{
    _p.disable_irq();
}

void PwmIn::enable()
{
    _p.enable_irq();
}

void PwmIn::rise()
{
    _period = _t.read();
    _t.reset();
}

void PwmIn::fall()
{
    _pulsewidth = _t.read();
}

struct product {
    float pulsewidth;
    float period;
    float cycle;
} acc_a[NR], acc_b[NR], acc_c[NR],acc_d[NR];


int main()
{
    char pbuffer[512]="---";
    int i;

    pc.baud(9600);
    sprintf(pbuffer, "Start test, baudrate is set to 9600 \n\r");
    pc.puts(pbuffer);

    a.disable();
    b.disable();
    while(1) {
        //-------------- sensor a--------------------
        a.enable(); // signal on input 50Hz is period of 20 milli second
        wait_ms(40); // signal on input 50Hz is period of 20 milli second
        for (i=0; i<NR; i++) {
            acc_a[i].pulsewidth= a.pulsewidth();    // Sensor A
            acc_a[i].period= a.period();            // Sensor A
            acc_a[i].cycle= a.dutycycle();          // Sensor A
        }
        a.disable();

        //-------------- sensor b--------------------
        b.enable(); // signal on input 50Hz is period of 20 milli second
        wait_ms(40); // 50Hz is period of 20 milli second
        for (i=0; i<NR; i++) {
            acc_b[i].pulsewidth= b.pulsewidth();    // Sensor B
            acc_b[i].period= b.period();            // Sensor B
            acc_b[i].cycle= b.dutycycle();          // Sensor B
        }
        b.disable();

        for (i=0; i<NR; i++) {
            sprintf(pbuffer, "a_pulse= %f, a_period= %f, a_c= %f, b_puls= %f, b_period= %f, b_cycle %f\n\r", acc_a[i].pulsewidth, acc_a[i].period, acc_a[i].cycle, acc_b[i].pulsewidth, acc_b[i].period, acc_b[i].cycle);
            pc.puts(pbuffer);
        }
        sprintf(pbuffer, "\n\r");
        pc.puts(pbuffer);
        wait_ms(100);
    }
}
