#include "mbed.h"

//////////////////////////////////////////
// GPa@quicknet.nl
/////////////////////////////////////////
//
// An unkwown ceramic capacitor is connected to
// pin21 via a 82 kilo ohm resister, the other
// capacitor terminal is connected to ground
//
// A ceramic capacitor is used becouse it is non polarized
//
//                                 ||
//     pin21-----RRRRRRR-----------||------- pin1 (GND)
//                            |    ||
//                82k ohm     |    ?? Farad
//                            |
//     pin20-------------------
//
// Mbed pins used
// Pin 20...... analog input
// Pin 21...... digital out
//////////////////////////////////////////
// How does it work
// measure voltage on pin 20
// If (not zero Volt) then wait
// else pin 21 goes high 3.3 Volt
// Capacitor is charging
// wait until 3.13 Volt being 3 Tou
// Theory step response on a first order system
//
// 1 x Tou= 63% final value
// 2 x Tou= 86% final value
// 3 x Tou= 95% final value
//
// Tou = R x C
// ==> C = Tou / R
//
// The measuring results are send via Teraterm to the PC screen
// Note 1)
// The tolerance range of a ceramic capacitor
// lies between 5 and 100%, not very accure at all.
// Note 2)
//
// Cap sizes are
// m = 10^-3  (mili)
// u = 10^-6  (micro)
// n = 10^-9  (nano)
// p = 10^-12 (pico)
// f = 10^-15 (femto)
/////////////////////////////////////////

AnalogIn ain(p20);
DigitalOut red(p21);
Serial pc(USBTX, USBRX); // tx, rx
Timer timer;

int main() {
    int i;
    double timec;
    double volt;       // Voltage measurement
    double cx;         // capacitance

    pc.baud(9600);
    pc.format(8,Serial::None,1);

    for (i=0; i<2250; i +=1)  {
        wait_ms(10);                  // deterime the number of measurements

        // Wait for 0.0 volt on input
        red.write(0);
        volt = 1;
        while (volt > 0.0001) {     // wait for 0.0 Volt
            wait_us(2);
            volt = ain.read();
        }
        // start to measure
        timer.reset();
        timer.start();
        red.write(1);               // output high

        while (volt < 3.13) {       // wait for 3.13 Volt
            volt = ain.read()*3.3;
        }
        timer.stop();
        timec=timer.read();
        red.write(0);               // output low

        // calculations
        cx = (double) timec/ (3 * 82000);

        pc.printf("Volt %3.2f, time %9.4f msec ", volt, timec*1000);
        if (cx < 1 and cx >= 0.001) {
            cx = cx *1000;
            pc.printf("Cap. is %5.1f milli Farad    ", cx);
        } else if (cx < 0.001 and cx >= 0.000001) {
            cx = cx *1000 *1000;
            pc.printf("Cap. is %5.1f micro Farad     ", cx);
        } else if (cx < 0.000001 and cx >= 0.000000001) {
            cx = cx *1000 *1000 *1000;
            pc.printf("Cap. is %5.1f nano Farad      ", cx);
        } else if (cx <  0.000000001 and cx >=  0.000000000001) {
            cx = cx *1000 *1000 *1000 *1000;
            pc.printf("Cap. is %5.1f pico Farad       ", cx);
        } else if (cx < 0.000000000001)
            pc.printf("Cx = %5.1f Out of range too small! ", cx);
        pc.printf("\r");
        pc.printf("\n");
    }
}