#include "mbed.h"
//--- Sparkfun part LCD-09067
//-------- LCD 16x2 ----------
// MBED p28-------------------RX
// MBED Vout------------------5V (text on LCD is wrong must be 3,3 Volt)
// MBED GND-------------------GND
// ---------------------------
// or
// KL25Z PTE0 (TX)-------------RX
// KL25Z Vout------------------3.3V (text on LCD is wrong must be 3,3 Volt)
// KL25Z GND-------------------GND
// ---------------------------


Serial lcd(PTE0, PTE1);       // tx, rx (mbed)
Serial pc(USBTX, USBRX);      // to PC

void clear_lcd(void);
void move_cursor(int, int);

int main() {
    int c=0;
    lcd.baud(9600);
    
    clear_lcd();
    lcd.printf("LCD-09067");
    wait(1);
    clear_lcd();

    while (1) {
        move_cursor(0,0);
        lcd.printf("pos %02d", c);
        wait_ms(200);
        move_cursor(1,0);
        lcd.printf("speed %02d", c);
        wait_ms(200);
        c += 1;
    }
}

//------clear the LCD display--------
void clear_lcd(void) {
    lcd.putc(0xFE);
    lcd.putc(0x01);
}

//----------- line 0 or 1----------
//----------- position 0/15--------
// (0,0) is top left position
// (1,15) is bottom right position
void move_cursor(int line, int pos) {
    int cp;
    cp = pos + (line * 64) +128;
    lcd.putc(0xFE);
    lcd.putc(cp);
    pc.printf("%d\r\n",cp);
}