/*
 * Author: G. Pathuis
 * Date: 02-12-17
 * Notes: HC05 connected to a KL25Z
 * Pair with PC use password 1234
 *
 * Four wire connection
 * HC05 to KL25Z
 * GND to GND
 * +5V to 5V
 * TX to pin PTE0
 * RX to pin PTE1
 *
 * Open Tera Term session to connect to KL25Z
 * and
 * Open second Tera Term session to read the Bluetooth
 * dongle in the PC set at 38400 baud
 *
 * http://www.wavesen.com
*/

#include "mbed.h"
#include "MODSERIAL.h"

MODSERIAL  pc(USBTX, USBRX, 256, 256);
MODSERIAL  blue(PTE0, PTE1, 256, 256);          // TX, RX

DigitalOut myled1(LED1);    //Blue
DigitalOut myled2(LED2);    //Green

// This function is called when a character received from PC
void pc_rxCallback(MODSERIAL_IRQ_INFO *q)
{
    int c;

    c= pc.getc();
    blue.putc(c);   // Send from PC to Blue
    pc.putc(c);     // Echo to PC
}

// This function is called when a character received from Bluetooth
void blue_rxCallback(MODSERIAL_IRQ_INFO *q)
{
    //char b;
    int b;

    myled1 = !myled1;
    b= blue.getc();
    pc.putc(b);
}

int main()
{
    char c = 'A';

    pc.baud(9600);
    pc.format(8,SerialBase::None,1);
    blue.baud(38400);                // Default Bluetooth Baudrate
    blue.format(8,SerialBase::None,1);

    pc.printf("Bluetooth HC-05\r\n");
    pc.printf("Make sure the terminal programm ends with CR-LF\r\n");
    pc.printf("\r\n");

    wait_ms(100);

    // Char from PC, interrupt service routine
    pc.attach(&pc_rxCallback, MODSERIAL::RxIrq);

    // Char from Bluetooth, interrupt service routine
    blue.attach(&blue_rxCallback, MODSERIAL::RxIrq);


    // Set up
    pc.puts("\r\nAT=");
    blue.puts("AT\r\n");
    wait_ms(1000);

    pc.puts("\r\nAT+VERSION?= ");
    blue.puts("AT+VERSION?\r\n");
    wait_ms(1000);

    pc.puts("\r\nAT+ADDR?= ");
    blue.puts("AT+ADDR?\r\n");
    wait_ms(1000);

    pc.puts("\r\nAT+NAME?= ");
    blue.puts("AT+NAME?\r\n");
    wait_ms(1000);

    pc.puts("\r\nAT+UART=38400,0,0");       //No parity, 1 Stop bit
    blue.puts("AT+UART=38400,0,0\r\n");     //No parity, 1 Stop bit
    wait_ms(1000);

    pc.puts("\r\nAT+UART?= ");
    blue.puts("AT+UART?\r\n");
    wait_ms(1000);

    pc.puts("\r\nAT+Role?= ");
    blue.puts("AT+Role?\r\n");
    wait_ms(1000);

    pc.puts("\r\nAT+RESET= ");
    blue.puts("AT+RESET\r\n");
    wait_ms(1000);


    // Send the alphabet
    while (1) {
        for (int loop = 0; loop < 512; loop++) {

            blue.printf("%c", c);
            c++;
            if (c > 'Z') c = 'A';
            if (loop > 510) loop  = 0;

            wait_ms(100);
        }
    }
}