#include "mbed.h"
#define ACK         0x06
#define LF          0x0A
#define CR          0x0D
#define NAK         0x15
#define MESS_LEN    100     // maximum message length
#define MAX_STR     20
#define STR_LEN     40

//-------------------------------------------------------------------
// Made by G.Pathuis (gpa@quicknet.nl)
// Program reads the information coming from the GPS receiver
// 65 channel SUP500F 10Hz GPS receiver with integrated Smart antenna
// See www.sparkfun.com GPS-09758 for details and documentation
// Hardware information
// SUP500F pin1 -------------MBED p13
// SUP500F pin2 -------------MBED p14
// SUP500F pin3 -------------MBED GND
// SUP500F pin4 -------------MBED Vout (3.3V @ 75mAmp)
// SUP500F pin5 -------------MBED Vout
// SUP500F pin6 -----LED-----MBED GND
// SUP500F pin7 -------------MBED GND
//
// IMPORTANT REMARK-------------------------------------------------
// This receiver has an integrated antenna and will not work when
// situated near a laptop, PC or MBED
// I used connecting (mbed-receiver) wires with a length of 1 meter
//------------------------------------------------------------------

Serial pc(USBTX, USBRX);    // tx, rx
Serial sup500(p13, p14);    // tx, rx

char nmea[MESS_LEN] = {0x00};   // raw message from the GPS receiver
char gp[MAX_STR][STR_LEN];      // 40 strings, length is 30

void read_nmea(void);           // read nmea message from gps module
int chop_message(void);         // chop the nmea messeage
void present_array(void);       // send a part of the available info to the laptop

int main() {
    pc.baud(9600);
    pc.format(8,Serial::None,1);

    sup500.baud(9600);
    sup500.format(8,Serial::None,1);

    pc.printf("Start lurking...\n\r");
    while (1) {
        read_nmea();
        chop_message();
        present_array();
    }
}

//--------------------read nmea from GPS unit--------------------
void read_nmea(void) {
    sup500.scanf("%s,",nmea);
    //pc.printf("Raw message %s \n\r",nmea); // just for testing
}

//---------------- chop the nmea message separated by comma's-----------
int chop_message(void) {
    for (int k=0; k<MAX_STR; k++) {          // just to make sure thet the char array is set to 0x00
        for (int l=0; l<STR_LEN; l++) {
            gp[k][l]= 0x00;
        };
    }
    int strcnt=0;                           // string counter
    int strpos=0;                           // position inside the string
    for (int k=0; k < MESS_LEN; k++) {
        if (nmea[k] == '*') {               // detect end of message is found
            gp[strcnt][strpos]= 0x00;       // close the string with 0x00
            return 0;                       // the work is done, end of this function
        }
        if (nmea[k] == 0x2c) {             // detect the comma
            if (strpos == 0) {
                gp[strcnt][0]= 'E';        // comma at position zero, string must be empty
                gp[strcnt][1]= 'm';        // comma at position zero, string must be empty
                gp[strcnt][2]= 'p';        // comma at position zero, string must be empty
                gp[strcnt][3]= 't';        // comma at position zero, string must be empty
                gp[strcnt][4]= 'y';        // comma at position zero, string must be empty
                gp[strcnt][5]= 0x00;       // comma at position zero, string must be empty
            } else {
                gp[strcnt][strpos]= 0x00;   // end the previous string
            }
            strcnt += 1;                    // increment to the next string
            strpos =0;                      // start at position zero
        } else {
            gp[strcnt][strpos]= nmea[k];    // add char to string
            strpos += 1;
        }
    }
    return 0;
}

// --------------- Dump only $GPGGA on the screen------------------
void present_array(void) {
    if ((gp[0][2]=='P') and (gp[0][3]=='G') and (gp[0][4]=='G') and (gp[0][5]=='A')) {
        pc.printf("Chop results ");
        for (int k=0; k<MAX_STR; k++) {
            pc.printf("r%d=%s ",k, gp[k]);
        }
        pc.printf("\n\r");
    }
}
