/**
 *  New filename:   Main.cpp
 *  @filename   :   epd1in54-demo.ino
 *  @brief      :   1.54inch e-paper display demo
 *  @author     :   Yehui from Waveshare
 *
 *  Copyright (C) Waveshare     September 5 2017
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documnetation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to  whom the Software is
 * furished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS OR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

// The 1.54 Incht E-paper Waveshare software is modified to work on a Kl25Z
// epaper --------- KL25X
// BUSY ----------- PTA13
// RST ------------ PTA17
// DC ------------- PTD5
// CS ------------- PTD0
// CLK ------------ PTD1
// DIN ------------ PTD2
// GND ------------ PTE3
// 3.3V ----------- PTD9
// NO connection with PTD3

#include "mbed.h"
#include "epd1in54.h"
#include "epdpaint.h"
#include "epdif.h"
#include "imagedata.h"

#define COLORED     0
#define UNCOLORED   1

Serial pc(USBTX, USBRX, 115200);

DigitalOut reset_pin(PTA17);
DigitalOut dc_pin(PTD5);
DigitalOut cs_pin(PTD0);
DigitalIn busy_pin(PTA13, PullNone);
SPI epaper(PTD2,PTD3,PTD1);  //MOSI, MISO, CLK
DigitalOut myled(LED2);
Timer timer;

/**
  * Due to RAM not enough in Arduino UNO, a frame buffer is not allowed.
  * In this case, a smaller image buffer is allocated and you have to
  * update a partial display several times.
  * 1 byte = 8 pixels, therefore you have to set 8*N pixels at a time.
  */
unsigned char image[1024];
Paint paint(image, 0, 0);    // width should be the multiple of 8
Epd epd;
unsigned long time_start_ms;
unsigned long time_now_s;

void setup()
{
    // put your setup code here, to run once:
    if (epd.Init(lut_full_update) != 0) {
        pc.printf("e-Paper init failed !!!");
        return;
    }

    /**
     *  there are 2 memory areas embedded in the e-paper display
     *  and once the display is refreshed, the memory area will be auto-toggled,
     *  i.e. the next action of SetFrameMemory will set the other memory area
     *  therefore you have to clear the frame memory twice.
     */

    epd.ClearFrameMemory(0xFF);   // bit set = white, bit reset = black
    epd.DisplayFrame();
    epd.ClearFrameMemory(0xFF);   // bit set = white, bit reset = black
    epd.DisplayFrame();

    paint.SetRotate(ROTATE_0);
    paint.SetWidth(200);
    paint.SetHeight(24);

    /* For simplicity, the arguments are explicit numerical coordinates */

    paint.Clear(COLORED);
    paint.DrawStringAt(30, 4, "Hello world!", &Font16, UNCOLORED);
    epd.SetFrameMemory(paint.GetImage(), 0, 10, paint.GetWidth(), paint.GetHeight());

    paint.Clear(UNCOLORED);
    paint.DrawStringAt(30, 4, "e-Paper Demo", &Font16, COLORED);
    epd.SetFrameMemory(paint.GetImage(), 0, 30, paint.GetWidth(), paint.GetHeight());

    paint.SetWidth(64);
    paint.SetHeight(64);

    pc.printf("Rectangle \n\r");
    paint.Clear(UNCOLORED);
    paint.DrawRectangle(0, 0, 40, 50, COLORED);
    paint.DrawLine(0, 0, 40, 50, COLORED);
    paint.DrawLine(40, 0, 0, 50, COLORED);
    epd.SetFrameMemory(paint.GetImage(), 16, 60, paint.GetWidth(), paint.GetHeight());

    paint.Clear(UNCOLORED);
    paint.DrawCircle(32, 32, 30, COLORED);
    epd.SetFrameMemory(paint.GetImage(), 120, 60, paint.GetWidth(), paint.GetHeight());

    paint.Clear(UNCOLORED);
    paint.DrawFilledRectangle(0, 0, 40, 50, COLORED);
    epd.SetFrameMemory(paint.GetImage(), 16, 130, paint.GetWidth(), paint.GetHeight());

    paint.Clear(UNCOLORED);
    paint.DrawFilledCircle(32, 32, 30, COLORED);
    epd.SetFrameMemory(paint.GetImage(), 120, 130, paint.GetWidth(), paint.GetHeight());
    epd.DisplayFrame();

    wait_ms(2000);

    if (epd.Init(lut_partial_update) != 0) {
        pc.printf("e-Paper init failed");
        return;
    }

    /**
     *  there are 2 memory areas embedded in the e-paper display
     *  and once the display is refreshed, the memory area will be auto-toggled,
     *  i.e. the next action of SetFrameMemory will set the other memory area
     *  therefore you have to set the frame memory and refresh the display twice.
     */
    epd.SetFrameMemory(IMAGE_DATA);
    epd.DisplayFrame();
    epd.SetFrameMemory(IMAGE_DATA);
    epd.DisplayFrame();

    time_start_ms = timer.read_ms();
}

void loop()
{
    // put your main code here, to run repeatedly:
    time_now_s = (timer.read_ms() - time_start_ms) / 1000;
    char time_string[] = {'0', '0', ':', '0', '0', '\0'};
    time_string[0] = time_now_s / 60 / 10 + '0';
    time_string[1] = time_now_s / 60 % 10 + '0';
    time_string[3] = time_now_s % 60 / 10 + '0';
    time_string[4] = time_now_s % 60 % 10 + '0';

    paint.SetWidth(32);
    paint.SetHeight(96);
    paint.SetRotate(ROTATE_270);

    paint.Clear(UNCOLORED);
    paint.DrawStringAt(0, 4, time_string, &Font24, COLORED);
    epd.SetFrameMemory(paint.GetImage(), 80, 72, paint.GetWidth(), paint.GetHeight());
    epd.DisplayFrame();
}

int main()
{
    timer.start();
    pc.printf("\n\r\n\r\n\rWaveshare 1.54 inch e-Paper start\n\r");
    setup();

    while(1) {
        loop();
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);
    }

}

