/**
 *  @filename   :   epdif.cpp
 *  @brief      :   Implements EPD interface functions
 *                  Users have to implement all the functions in epdif.cpp
 *  @author     :   Yehui from Waveshare
 *
 *  Copyright (C) Waveshare     August 10 2017
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documnetation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to  whom the Software is
 * furished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS OR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "epdif.h"
#include "epd1in54.h"

extern DigitalOut reset_pin;
extern DigitalOut dc_pin;
extern DigitalOut cs_pin;
extern DigitalIn busy_pin;
extern SPI epaper;
extern DigitalOut myled;

EpdIf::EpdIf()
{
};

EpdIf::~EpdIf()
{
};


void EpdIf::DigitalWrite(int pin, int value)
{
    using namespace std;
    switch(pin) {
        case 0:
            reset_pin.write(value);
            break;
        case 1:
            dc_pin.write(value);
            break;
        case 2:
            cs_pin.write(value);
            break;
    }
}

int EpdIf::DigitalRead(int pin)
{
    return busy_pin.read();
}

void EpdIf::DelayMs(unsigned int delaytime)
{
    wait_ms(delaytime);
}

void EpdIf::SpiTransfer(unsigned char data)
{
    cs_pin.write(LOW);
    epaper.write(data);
    cs_pin.write(HIGH);
}

int EpdIf::IfInit(void)
{
    epaper.frequency(2000000);
    //epaper.format(8,0);
    //SPI.beginTransaction(SPISettings(2000000, MSBFIRST, SPI_MODE0));
    return 0;
}


