#include "mbed.h"
#include <string>
#include <ctype.h>

// E45-TTL-100 RADIO------KL25Z
// AUX--------------------PTD4
// M1---------------------PTA12
// M0---------------------PTA4
// RXD--------------------PTE22(TX)
// TXD--------------------PTE23(RX)
// LORA Radio Transmits @ 868 mHz
// Expected range 2000m
// https://quadmeup.com/wp-content/uploads/2017/09/E45-TTL-100_Datasheet_EN_v1.2.pdf

Ticker timer;
Serial pc(USBTX, USBRX);    // tx, rx of the pc
Serial e45(PTE22, PTE23);   // tx, rx of the E45 radio

InterruptIn aux(PTD4);              // AUX the E45 radio
DigitalOut m1(PTA12,PullUp);        // M1 the E45 radio
DigitalOut m0(PTA4, PullUp);        // M0 the E45 radio
DigitalOut myled(LED_RED);          // KL25Z RED led

int ping=1;      // this number bounces between radios 
bool send_something_flag= 0;         // Send flag

void flank_up()
{
    myled=1;        //Rising Edge Detected
}

void flank_down()
{
    myled=0;        //Falling Edge Detected
}

void timer_func()   // Send something every 3 seconds
{
    send_something_flag= 1;  // Set the send Flag
}

int main()
{
    int count=0;
    string incoming;
    char c;

    pc.baud(115200);
    e45.baud(9600);                         // Default for E45
    e45.format(8, SerialBase::None, 1);     // Default for E45
    pc.printf("\n\r\nE45-TTL-100 LORA\n\r");

    aux.rise(&flank_up);       //Service RISING EDGE Interrupt
    aux.fall(&flank_down);     //Service FALLING EDGE Interrupt

    // select mode
    // Transparant Transmission
    if (myled ==1) {        //Check ready or not
        while(myled==0) {   //Wait when not yet ready
            count++;
            if (count > 2000000) {  //Kill time
                count=0;
                pc.printf("Wait for AUX Rising edge ");
            }
        }
    }
    wait_ms(2);
    m0= 0;      //Set transparant mode
    m1= 0;      //Set transparant mode
    wait_ms(1);

    pc.printf("E45 is now ready to send and receive \n\r");
    timer.attach(&timer_func, 3.0);

    while(1) {
        if (ping>9999) ping=1;

        if (send_something_flag==1) {
            if (myled == 1)  {   // AUX is high (Buffer empty), send something
                wait_ms(3);
                ping++;          // Increase the value
                e45.printf("%04d\n\r", ping);
                while(myled==0) {
                }
                send_something_flag=0;
                pc.printf("\n\rRadio has sent %04d\n\r", ping);
            }
        }

        if (myled == 0)  {      // AUX is low, Chars received
            incoming= "";     // Clear the string
            while(myled==0) {
                if (e45.readable()) {
                    c=e45.getc();
                    if (isdigit(c))
                        incoming += c;
                } else {            // End transmission
                    if (incoming.length()==4) {
                        ping= atoi(incoming.c_str());
                        pc.printf("incoming value %4d \n\r", ping);
                        incoming= "";   // Clear the string
                    }
                }
            }
        }
    }
}
