#include "mbed.h"
#include "Rtc_Ds1307.h"
#include "DebouncedIn.h" 
#include "QEI.h"
 
Rtc_Ds1307 rtc(PTE0,PTE1);        //Puertos para el modulo
Serial pc(USBTX, USBRX, "pc");    //Puertos para el PC
QEI wheel (PTD5, PTD0, NC, 100);  //Configuracion encoder
DebouncedIn Boton(PTA13);        //Boton Encoder
DigitalOut led1(PTD2);          //Salida

int Dia=0;
int Mes=0;
int Anio=2015;
int Horas=0;
int Minutos=0;
int Segundos=0;
 
char buffer[128];
int readptr = 0;
 
int main() 
    {
    char c;
    Rtc_Ds1307::Time_rtc tm = {};
    
    while(1) 
    {      
    pc.printf("*************************************\n");
    pc.printf("* Menu for RTC Test :               *\n");
    pc.printf("* leer  - reads the clock           *\n");
    pc.printf("* empezar - start the clock           *\n");
    pc.printf("* parar  - stop the clock            *\n");
    pc.printf("* configurar - write the clock           *\n");
    pc.printf("* ena   - enable Square wave output *\n");
    pc.printf("* dis   - disable square wave outp. *\n");
    pc.printf("*************************************\n");
        
        while( (c = pc.getc()) != '\n')
        {
        buffer[readptr++] = c;
        }
        buffer[readptr++] = 0;
        
        // para leer los valores que tiene el reloj 
        
            if (strncmp(buffer, "leer", 4) == 0)  
            {
            pc.printf("Performing read operation\n");
                if (rtc.getTime(tm) ) 
                {
                pc.printf("La hora es: %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);  // coloca en pantalla la hora actual que hay almacenada 
                pc.printf("La fecha es: %s, %02d/%02d/%04d\n", rtc.weekdayToString(tm.wday), tm.mon, tm.date, tm.year); // coloca en pantalla la fecha actual que hay almacenada 
                }
            
             }   
        else if (strncmp(buffer, "configurar", 5) == 0)  // se empieza por configurar el reloj interno
            pc.printf("Dia (0..31)");
            pc.scanf("%d", &tm.date); // coloca lo que uno le ingrese como dia
            pc.printf("Mes (1..12)");
            pc.scanf("%d", &tm.mon); // coloca lo que uno le ingrese como mes
            pc.printf("Anio");
            pc.scanf("%d", &tm.year); // coloca lo que uno le ingrese como año
            pc.printf("Hora (0..23)");
            pc.scanf("%d", &tm.hour); // coloca lo que uno le ingrese como hora
            pc.printf("Minutos (0..59)");
            pc.scanf("%d", &tm.min); // coloca lo que uno le ingrese como minutos
            pc.printf("Segundos (0..59)");
            pc.scanf("%d", &tm.sec); // coloca lo que uno le ingrese como segundos
            pc.printf("Performing write operation\n");
            
            while(pc.readable()) 
            pc.getc();
            rtc.setTime(tm, false, false);
            }
            
            // para empezar a correr el reloj que se programó arriba
            
        else if (strncmp(buffer, "empezar", 5) == 0)  
            {
            readptr = 0;
            pc.printf("Dispositivo Iniciado\n");
            rtc.startClock();
            goto alarma;
                        
        }
        else if (strncmp(buffer, "parar", 4) == 0) // para parar el reloj
        {
            pc.printf("Performing stop operation\n");
            rtc.stopClock();
        }
        else if (strncmp(buffer, "ena", 3) == 0) 
        {
            int rs;
            pc.printf("Please specify the frequency : [0 = 1Hz, 1 = 4.096kHz, 2 = 8.192kHz, 3 = 32.768kHz] ");
            scanf("%d", &rs);
            pc.printf("Enabling the output with %d option\n", rs);
            rtc.setSquareWaveOutput(true, (Rtc_Ds1307::SqwRateSelect_t)rs);
        }
        else if (strncmp(buffer, "dis", 3) == 0)
        {
            pc.printf("Disableing square wave output\n");
            rtc.setSquareWaveOutput(false, Rtc_Ds1307::RS1Hz);
        }
        else 
        {
            pc.printf("syntax error\n");
        }
        readptr = 0;
        }
        
         //se inicia a configurar la alarma
                 
        alarma:         
        pc.printf("Configuracion de la alarma\n");
        
        
        Dia:             //empieza con el dia 
        while(1)
        {         
            Dia=Dia+wheel.getPulses();  //con el encoder se aumenta el dia 
            wheel.reset();
     
            if(Dia>=31)
            {               //como el dia no tiene mas de 31 dias, se mantiene en 31 al ingresar un valor diferente
            Dia=31;
            }
            else if (Dia<=0)
            {          //no se pueden ingresar numeros negativos
             Dia=0;
            }
     pc.printf("Dia=  %d\n",Dia);        //muestra el valor 
    
    
    if(Boton.falling())
    {                    //presionando el encoder cambiamos al configurar el mes
    goto Mes;
    }
    }
        
Mes:                           //Configuracion del Mes para la alarma

        while(1)
        {
         
        Mes=Mes+wheel.getPulses();     //con el encoder aumentamos el mes 
        wheel.reset();
        
        if(Mes>=12)
        {                   //maximo a 12 meses si es mayor, matiene a 12
                Mes=12;
            }
            else if (Mes<=0)
            {                 //se mantiene en 0 
             Mes=0;
            }
     pc.printf("Mes=  %d\n ",Mes);          //muestra el mes
    
    
    if(Boton.falling())
    {
        goto Anio;
    }
    
            
    }
     
     Anio:
        while(1)
        {         
            Anio=Anio+wheel.getPulses();
            wheel.reset();
 
     
            if(Anio>=3000) //se mantiene hasta el año 3000 si se ingresa un año mas grande
            {
                Anio=3000;
            }
            else if (Anio<=2015){ //como estamos en el 2015 una alarma no puede sonar antes de esa fecha
             Anio=2015;
            }
     pc.printf("Anio=  %d\n",Anio);
    
    
    if(Boton.falling()) //presionando el encoder cambiamos a configurar la hora
    {
        goto Horas;
    }
        
    }
    Horas:
        while(1)
        {
        
        Horas=Horas+wheel.getPulses();
            wheel.reset();
        
     
            if(Horas>=23)
            {
                Horas=23;
            }
            else if (Horas<=0)
            {
             Horas=0;
            }
     pc.printf(" Hora=%d\n ",Horas);
    
    
    if(Boton.falling()){  //presionando el encoder cambiamos a configurar los minutos
        goto Minutos;
    }
            
            
    }
     Minutos:
        while(1)
        {
         
            Minutos=Minutos+wheel.getPulses();
            wheel.reset();
     
     
            if(Minutos>=59)
            {
                Minutos=59;
            }
            else if (Horas<=0)
            {
             Minutos=0;
            }
     pc.printf(" Minuto=%d\n ",Minutos);
    
    
    if(Boton.falling())
    {
        goto comp;
    }
   
    }
    
    comp:       // para que muestre cuándo quedó configurada la alarma
    
    pc.printf("La alarma se programara el:   \n");
    pc.printf(" Dia=%d    Mes=%d    Anio=%d    Hora=%d    Minuto=%d    Segundo=%d\n ",Dia,Mes,Anio,Horas,Minutos,Segundos);
    
    wait (3);
    
    while(1)
    {
       rtc.getTime(tm);
       pc.printf("Hora actual:  %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
       pc.printf("Fecha actual:  %02d/%02d/%04d\n", tm.mon, tm.date, tm.year);
    if(tm.hour>=Horas && tm.min>=Minutos &&tm.sec>=Segundos && tm.mon>=Mes && tm.date>=Dia && tm.year>=Anio){
        led1=0;
      //  pc.printf("La alarma se ha activado:   \n");
    }
    else {
        led1=1;
        }
        wait(1);
    } 
    }