#include "main.hh"

int main(){
    #ifdef OLED
    bouton.rise(interruption_bouton);
    initOLED();
    #endif
        
    while(1) {
      readData();
      wait(DUREE_OFF);
    }
}

#ifdef FLOOR_TEMPERATURE
float temp_sol()
{
    DS.convertTemperature(true, DS1820::all_devices);
    if (DS.unassignedProbe(D2)){
        #ifdef DEBUG
        pc.printf( "D3 not assigned\n\r");
        #endif
    }
    #ifdef DEBUG
    pc.printf("temp sol: %.1f\n\r", DS.temperature());
    #endif
    return DS.temperature();
}
#endif

#ifdef FLOOR_HUMIDITY
int fct_humidity_sol(void)
{
    float val_min = 0.377;
    float val_max = 0.772;
    float mesure, mesure_etalonnee;
    mesure = capteur_humidity_sol.read();
    mesure_etalonnee = (1-((mesure - val_min)/(val_max - val_min)))*100;
    #ifdef DEBUG
    pc.printf("hum sol: %d\n\r", (int) mesure_etalonnee);
    #endif
    return (int) mesure_etalonnee;
}
#endif

#ifdef RGB
void fct_RGB(void)
{
    int somme;
    uint16_t clear, red, green, blue;
    if (!RGBsens.begin())
    {
        #ifdef DEBUG
        pc.printf("No TCS34725 found ... check your connections");
        #endif
        //while (1); // halt!
    }
        RGBsens.getRawData(&red, &green, &blue, &clear);
        somme = red + green + blue;
        pr = red*100/somme;
        pg = green*100/somme;
        pb = blue*100/somme;
        lum = clear;
        #ifdef DEBUG
        pc.printf("luminosite : %d \n\r", lum);
        pc.printf("rouge:%d vert:%d bleu:%d \n\r", pr, pg, pb);
        #endif
}
#endif

#ifdef SIGFOX
void sendDataSigfox(void){
    #ifdef DEBUG
    pc.printf("Sending Data to Sigfox \n\r");
    #endif
    short tempSol_short, tempAir_short;
    tempSol_short = (short)(temperature_sol*10);
    tempAir_short = (short)(temperature_air*10);

    wisol.printf("AT$SF=%04x%02x%04x%02x%04x%02x%02x%02x\r\n",tempSol_short, humidity_sol, tempAir_short, humidity_air, lum, pr, pg, pb);
}
#endif

#ifdef OLED
void oledData(void){
    #ifdef DEBUG
    pc.printf("Displaying Data\r\n");
    #endif
    if(!oled_on){
        oled.wake();
        oled_on = 1;
    }
    oled.cls(0,1);
    oled.locate(0,0);
    oled.printf("AIR T : %.1f", temperature_air);
    oled.locate(1,0);
    oled.printf("AIR H : %d", humidity_air);
    oled.locate(3,0);
    oled.printf("FLOOR T : %.1f", temperature_sol);
    oled.locate(4,0);
    oled.printf("FLOOR H : %d", humidity_sol);
    oled.locate(6,0);
    oled.printf("Light : %d", lum);
    oled.locate(7,0);
    oled.printf("R %d G %d B %d", pr, pg, pb);
    oled.redraw();
}
#endif

void readData(void){
    #ifdef DEBUG
    pc.printf("Reading Data\n\r");
    #endif
    #ifdef FLOOR_TEMPERATURE
    temperature_sol = temp_sol();
    #endif
    #ifdef FLOOR_HUMIDITY
    humidity_sol = fct_humidity_sol();
    #endif
    #ifdef AIR_PARAMETERS
    temperature_air = sht.readTemp();
    humidity_air = sht.readHumidity();
    #endif
    #ifdef DEBUG
    printf("hum air: %d\n\r", humidity_air);   
    printf("temp air: %.1f\n\r", temperature_air);  
    #endif
    #ifdef RGB  
    fct_RGB();
    #endif
    #ifdef SIGFOX
    sendDataSigfox();
    #endif
    #ifdef OLED
    if(oled_on)
        oledData();
    #endif
}

void interruption_bouton(){
    bouton.disable_irq();
    #ifdef DEBUG
    pc.printf("Button interrupt\r\n");
    #endif
    #ifdef OLED
    if(!oled_on){
        oledData();
        timeScreen.attach(&turnOffScreen,DUREE_ECRAN_ON);
    }
    #endif
    bouton.enable_irq();
}

#ifdef OLED
void turnOffScreen(void){
    #ifdef DEBUG
    pc.printf("Turning off screen \n\r");
    #endif
    timeScreen.detach();
    oled_on = 0;
    oled.sleep();
}
#endif

#ifdef OLED
void initOLED(void){
    oled.wake();
    oled.init();
    oled.cls(0,1);
    oled.locate(4,4);
    oled.printf("2PA2S");
    oled.redraw();
    wait(1);
    oled.cls(0,1);
    oled.sleep();
}
#endif