#pragma once

#include "define.hh"
#include "mbed.h"
#include "DS1820.h"
#include "SHT21_ncleee.h"
#include "Adafruit_TCS34725.h"
#include "ssd1306.h"

#define DUREE_OFF 10                     // Durée en seconde entre deux mesures
#define DUREE_ECRAN_ON  5                   // Durée en seconde d'éveil de l'écran

#define I2C_SDA D4
#define I2C_SCL D5

Ticker timeScreen;

#ifdef DEBUG
Serial pc(SERIAL_TX, SERIAL_RX);
#endif

#ifdef SIGFOX
Serial wisol(D1,D0);
#endif

I2C i2c(I2C_SDA, I2C_SCL);

#ifdef OLED
SSD1306 oled(D12, A6);
#endif

InterruptIn bouton(D10);

// Capteurs
#ifdef FLOOR_TEMPERATURE
DS1820 DS(D2);                              // temperature sol
#endif

#ifdef FLOOR_HUMIDITY
AnalogIn capteur_humidity_sol(A0);          // humidité sol
#endif

#ifdef AIR_PARAMETERS
SHT21 sht(&i2c);                            // humidité + température air
#endif

#ifdef RGB
Adafruit_TCS34725 RGBsens = Adafruit_TCS34725(&i2c, TCS34725_INTEGRATIONTIME_154MS, TCS34725_GAIN_1X);  // RGB
#endif

// Fonctions
float   temp_sol(void);
int     fct_humidity_sol(void);
void    fct_RGB(void);
void    sendDataSigfox(void);
void    oledData(void);
void    readData(void);
void    interruption_bouton(void);
void    turnOffScreen(void);
void    initOLED(void);

// Variables globales
bool            oled_on = 0;             // flag OLED
float           temperature_sol;
unsigned char   humidity_sol;
float           temperature_air;
unsigned char   humidity_air;
unsigned char   pr, pg, pb;
unsigned short  lum;
