#pragma once

#include "define.hh"
#include "mbed.h"
#include "DS1820.h"
#include "DHT.h"
#include "Adafruit_TCS34725.h"
#include "ssd1306.h"
#include "standard_font.h"
#include "bold_font.h"
#include "WakeUp.h"

#define DUREE_OFF 30                        // Durée en seconde entre deux mesures + 8 secondes pour le module sigfox dans le code
#define DUREE_ECRAN_ON  10                 // Durée en seconde d'éveil de l'écran

#define NB_MESURES 100

#define BATTERIE_MIN 30
#define BATTERIE_MAX 39


#ifdef INTERRUPTEUR
DigitalOut interrupteur(D11);
#endif

#ifdef DEBUG
Serial pc(SERIAL_TX, SERIAL_RX);
#endif

#ifdef SIGFOX
Serial wisol(D1,D0);
#endif

//I2C i2c_1(D4, D5);
I2C i2c_2(D12,A6);

#ifdef OLED
// D6 D9 D10 A4 D2
SSD1306 oled(PB_1, PA_8, PA_11, PA_5, PA_12);
#endif

//Mesure niveau batterie
#ifdef BATTERY_LVL
AnalogIn battery(A1);
#endif

InterruptIn bouton(A2);

// Capteurs
#ifdef FLOOR_TEMPERATURE
DS1820 ds1820(A3);                              // temperature sol
#endif

#ifdef FLOOR_HUMIDITY
AnalogIn capteur_humidity_sol(A0);          // humidité sol
#endif


#ifdef RGB
Adafruit_TCS34725 RGBsens = Adafruit_TCS34725(&i2c_2, TCS34725_INTEGRATIONTIME_154MS, TCS34725_GAIN_1X);  // RGB
#endif

#ifdef AIR_PARAMETERS_DHT22
DHT dht_sensor(D5, 22);
#endif

// Fonctions
void    air_temp_hum(void);
void    temp_sol(void);
int     fct_humidity_sol(void);
void    fct_RGB(void);
void    sendDataSigfox(void);
void    oledData(void);
void    readData(void);
void    interruption_bouton(void);
void    turnOffScreen(void);
void    initOLED(void);
void    readBatteryLvl(void);


// Variables globales
bool            oled_on = 0;             // flag OLED
float           temperature_sol;
unsigned char   humidity_sol;
float           temperature_air;
unsigned char   humidity_air;
unsigned char   pr, pg, pb;
unsigned short  lum;
char            vBat;
bool            flag_readData = true;
