#include "main.hh"

int main(){
    #ifdef DEEPSLEEP
    //WakeUp::calibrate();
    #endif

    #ifdef INTERRUPTEUR
    interrupteur = 1;
    #endif
    
    #ifdef OLED
    bouton.rise(interruption_bouton);
    initOLED();
    #endif
        
    while(1) {
        if(flag_readData)
            readData();
        flag_readData = true;
        #ifndef DEEPSLEEP
        wait(DUREE_OFF);
        #endif
        #ifdef DEEPSLEEP
        if(oled_on){
            wait(DUREE_ECRAN_ON);
            turnOffScreen();
            flag_readData = false;
        }
        else{
            WakeUp::set_ms(DUREE_OFF*1000);
            deepsleep();
        }
      #endif
    }
}

#ifdef AIR_PARAMETERS_DHT22
void air_temp_hum(){
    int err;
    wait(1);
    do{
        err = dht_sensor.readData();
        wait(1);
    }while(err != 0);
    temperature_air = dht_sensor.ReadTemperature(CELCIUS);
    humidity_air = dht_sensor.ReadHumidity();
}
#endif

#ifdef FLOOR_TEMPERATURE
void temp_sol()
{
    int result = 0;
    ds1820.begin();
    ds1820.startConversion();   // start temperature conversion from analog to digital
    wait(1.0);                  // let DS1820 complete the temperature conversion
    result = ds1820.read(temperature_sol); // read temperature from DS1820 and perform cyclic redundancy check (CRC)
    #ifdef DEBUG
    switch (result) {
        case 0:                 // no errors -> 'temp' contains the value of measured temperature
            pc.printf("temp = %3.1f C\r\n", temperature_sol);
            break;

        case 1:                 // no sensor present -> 'temp' is not updated
            pc.printf("no sensor present\n\r");
            break;

        case 2:                 // CRC error -> 'temp' is not updated
            pc.printf("CRC error\r\n");
    }
    #endif
    
}
#endif

#ifdef FLOOR_HUMIDITY
int fct_humidity_sol(void)
{
    float val_min = 0.377;
    float val_max = 0.772;
    float mesure, mesure_etalonnee;
    mesure = capteur_humidity_sol.read();
    mesure_etalonnee = (1-((mesure - val_min)/(val_max - val_min)))*100;
    #ifdef DEBUG
    pc.printf("hum sol: %d\n\r", (int) mesure_etalonnee);
    #endif
    return (int) mesure_etalonnee;
}
#endif

#ifdef RGB
void fct_RGB(void)
{
    int somme;
    uint16_t clear, red, green, blue;
    if (!RGBsens.begin())
    {
        #ifdef DEBUG
        pc.printf("No TCS34725 found ... check your connections");
        #endif
        //while (1); // halt!
    }
        RGBsens.getRawData(&red, &green, &blue, &clear);
        somme = red + green + blue;
        pr = red*100/somme;
        pg = green*100/somme;
        pb = blue*100/somme;
        lum = (unsigned short) RGBsens.calculateLux(red, green, blue);
        #ifdef DEBUG
        pc.printf("luminosite : %d \n\r", lum);
        pc.printf("rouge:%d vert:%d bleu:%d \n\r", pr, pg, pb);
        #endif
}
#endif

#ifdef SIGFOX
void sendDataSigfox(void){
    #ifdef DEBUG
    pc.printf("Sending Data to Sigfox \n\r");
    #endif
    short tempSol_short, tempAir_short;
    tempSol_short = (short)(temperature_sol*10);
    tempAir_short = (short)(temperature_air*10);

    wisol.printf("AT$SF=%04x%02x%04x%02x%04x%02x%02x%02x%02x\r\n",tempSol_short, humidity_sol, tempAir_short, humidity_air, lum, pr, pg, pb, vBat);
}
#endif

#ifdef OLED
void oledData(void){
    #ifdef DEBUG
    pc.printf("Displaying Data\r\n");
    #endif
    
    if(!oled_on){
        oled.wake();
        oled.clear();
        oled_on = 1;
    }
    oled.clear();
    oled.printf("AIR T : %.1f", temperature_air);
    oled.printf("\n\r");
    oled.printf("AIR H : %d", humidity_air);
    oled.printf("\n\r\n\r");
    oled.printf("FLOOR T : %.1f", temperature_sol);
    oled.printf("\n\r");
    oled.printf("FLOOR H : %d", humidity_sol);
    oled.printf("\n\r\n\r");
    oled.printf("Light : %d", lum);
    oled.printf("\n\r");
    oled.printf("R %d G %d B %d", pr, pg, pb);
    oled.update();
}
#endif

void readData(void){
    #ifdef INTERRUPTEUR
    interrupteur = 1;
    wait_ms(100);
    RGBsens.begin();
    wait_ms(100);
    #endif
    #ifdef DEBUG
    pc.printf("Reading Data\n\r");
    #endif
    #ifdef FLOOR_TEMPERATURE
    temp_sol();
    #endif
    #ifdef FLOOR_HUMIDITY
    humidity_sol = fct_humidity_sol();
    #endif
    #ifdef AIR_PARAMETERS_DHT22
    air_temp_hum();
    #endif
    #ifdef DEBUG
    printf("hum air: %d\n\r", humidity_air);   
    printf("temp air: %.1f\n\r", temperature_air);  
    #endif
    #ifdef RGB  
    fct_RGB();
    #endif
    #ifdef BATTERY_LVL
    readBatteryLvl();
    #endif
    #ifdef SIGFOX
    sendDataSigfox();
    #endif
    #ifdef OLED
    if(oled_on)
        oledData();
    #endif
    #ifdef INTERRUPTEUR
    wait(8);                // Il faut du temps au module SigFox pour envoyer les données
    interrupteur = 0;
    #endif
}

void interruption_bouton(){
    bouton.disable_irq();
    #ifdef DEBUG
    pc.printf("Button interrupt\r\n");
    #endif
    #ifdef OLED
    if(!oled_on){
        oledData();
    }
    #endif
    bouton.enable_irq();
}

#ifdef OLED
void turnOffScreen(void){
    #ifdef DEBUG
    pc.printf("Turning off screen \n\r");
    #endif
    oled_on = 0;
    oled.sleep();
}
#endif

#ifdef OLED
void initOLED(void){
    oled.on();
    oled.initialise();
    oled.clear();
    oled.set_contrast(255);
    oled.set_font(bold_font, 8);
    oled.printf("================");
    oled.printf("\n\r");
    oled.printf("      2PA2S");
    oled.printf("\n\r\n\r");
    oled.printf("FRAYSSE GERMAIN");
    oled.printf("\n\r\n\r");
    oled.printf("   DUPLESSIS");
    oled.printf("\n\r");
    oled.printf("================");
    oled.update();
    wait(10);
    oled.clear();
    oled.update();
    oled.sleep();
}
#endif

void readBatteryLvl(void){
    float calcVbat = 0;
    int batIn = 0;
    float ain = battery.read();
    for(int i = 0; i < NB_MESURES; i++){
        batIn = 100*ain;
        calcVbat += ((float)(batIn - BATTERIE_MIN)/(float)(BATTERIE_MAX - BATTERIE_MIN))*100;
    }
    vBat = (char)(calcVbat/NB_MESURES);
    #ifdef DEBUG
    pc.printf("batIn = %d\n\r", batIn);
    pc.printf("calcVbat = %d\n\r", calcVbat);
    pc.printf("vBat = %d\n\r", vBat);
    #endif
}