#include "mbed.h"
#include "QEI.h"
#include "HIDScope.h"

// Definiëren van alle poorten

DigitalIn encoder1A (D13); //Channel A van Encoder 1
DigitalIn encoder1B (D12); //Channel B van Encoder 1
DigitalIn encoder2A (D11); //Channel A van Encoder 2, kan niet op D15
DigitalIn encoder2B (D10); //Channel B van Encoder 2, kan niet op D14
DigitalOut motor1 (D7);
PwmOut pwm_motor1 (D6);
DigitalOut motor2 (D4);
PwmOut pwm_motor2 (D5);
HIDScope    scope( 4 );
Ticker      sample_timer;

double t;
float pi=3.14159;
float Aout;
float PWMAout;
int counts1;
int counts2;
const int cw=0;
const int ccw=1;

void sample()
{
    scope.set(0, counts1);
    scope.set(1, counts2);
    scope.set(2, Aout);
    scope.set(3, PWMAout);
    scope.send();
}


int main() {
    const double frequency_pwm = 100.0;
    pwm_motor1.period(1.0/frequency_pwm);
    pwm_motor2.period(1.0/frequency_pwm);
    QEI Encoder1(D12, D13, NC, 32); //maakt de encoder aan, NC niet aanwezig, 32 bits
    QEI Encoder2(D10, D11, NC, 32); //maakt de encoder aan, NC niet aanwezig, 32 bits
    sample_timer.attach(&sample, 0.001);
 
    while(true){
      for (t=0; t<10; t=t+0.05) {
                Aout=1*sin(2*pi*t);
                PWMAout=(Aout+1)/2;
            if (Aout >=0) //clockwise rotation
                {motor1=cw;        
            }
        else    //counterclockwise rotation 
            {motor1=ccw;         
            }
        pwm_motor1.write(PWMAout);
    
        if (Aout >=0) //clockwise rotation
            {motor2=cw;        
            }
        else    //counterclockwise rotation 
            {motor2=ccw;         
            }
        pwm_motor2.write(PWMAout);
    
        counts1 = Encoder1.getPulses();
        counts2 = Encoder2.getPulses(); 
     }
            
    
    }
 }

   