#include "mbed.h"
#include "BiQuad.h"
#include "HIDScope.h"

//#define SERIAL_BAUD 115200

AnalogIn    emg0( A0 );
AnalogIn    emg1( A1 );
//Serial pc(USBTX,USBRX);

Ticker      sample_timer, average_timer, filter_timer, t;
HIDScope    scope( 6 );
DigitalOut  led1(LED_RED);
DigitalOut  led2(LED_BLUE);

volatile int time_passed = 0;
volatile bool filter_timer_go=false;

double EMGright, EMGleft, inR;
double averageEMGr =0;
double averageEMGl =0;
double outRnotch2 = 0;
double outLnotch2 = 0;

void filter_timer_act(){filter_timer_go=true;};

BiQuadChain bcq1;
BiQuadChain bcq2;
// Notch filter wo=50; bw=wo/35
BiQuad bq1(9.9821e-01,-1.9807e+00,9.9821e-01,-1.9807e+00,9.9642e-01);
// High pass Butterworth filter 2nd order, Fc=10;
BiQuad bq2(9.8239e-01,-1.9648e+00,9.8239e-01,-1.9645e+00,9.6508e-01);
// Low pass Butterworth filter 2nd order, Fc = 8;
BiQuad bq3(5.6248e-05,1.1250e-04,5.6248e-05,-1.9787e+00,9.7890e-01);
// Low pass Butterworth filter 4th order, Fc = 450; plited up in 2x2nd order
BiQuad bq4(1.0000e+00,2.0000e+00,1.0000e+00,-4.6382e-01,8.9354e-02);
BiQuad bq5(1.0000e+00,2.0000e+00,1.0000e+00,-6.3254e-01,4.8559e-01);

// Low pass Butterworth filter 2th order, Fc = 450;
BiQuad bq6(1.7509e-01,3.5018e-01,1.7509e-01,-5.1930e-01,2.1965e-01);


void KeepTrackOfTime()
{
    time_passed++;
}

// In the following: R is used for right arm, L is used for left arm!
void FilteredSample()
{   
    double inR = emg0.read();
    double inL = emg1.read();
    
    double outRnotch = bcq1.step(inR);      //notch and highpass for detrend
    double outRrect = fabs(outRnotch);      //calculate abs with fabs      
    double outRlow = bcq2.step(outRrect);   //lowpass for envelope
        
    double outLnotch = bcq1.step(inL);      //notch and highpass for detrend
    double outLrect = fabs(outLnotch);      //calculate abs with fabs
    double outLlow = bcq2.step(outLrect);   //lowpass for envelope
    
    //pc.printf("Detrend EMG = %f\n\r",inR);
    //pc.printf("EMG signal= %f\n\r",emg0.read());
    //pc.printf("average EMG right = %f\n\r",averageEMGr);
    
    /*
    scope.set(0, inR);          //emgsignal
    scope.set(1, outRnotch);    //highpass+notch filtered
    scope.set(2, outRnotch2);   //abscalc ifelse
    scope.set(3, outRrect2);    //abscalc fabs
    scope.set(4, outRlow);      //abs ifelse + lowpass
    scope.set(5, outRlow2);     //abs fabs + lowpass
    */
    
    scope.set(0, inR);          //emgsignal right
    scope.set(1, outRlow);      //emg filtered: highpass, notch, abs, lowpass
    scope.set(2, inL);          //emgsignal left
    scope.set(3, outLlow);      //emg filtered: highpass, notch, abs, lowpass
    scope.send();
    // To indicate that the function is working, the LED is toggled*/
    led2 = !led2;
}

int main()
{   
    //pc.baud(115200);
    led1=1;
    led2=1;
    led2=!led2;
    //t.attach(&KeepTrackOfTime,1.0); //taking the time in seconds

    bcq1.add(&bq1).add(&bq2);
    bcq2.add(&bq6).add(&bq3); //bcq2.add(&bq3).add(&bq4).add(&bq5);    //450Hz Lowpass does not work
    
      
    filter_timer.attach(&filter_timer_act, 0.0004); //2500Hz (same as with filter coefficients on matlab!!! Thus adjust!)
        //pc.printf("\rMain-loop\n\r");
        //pc.printf("Detrend EMG = %f\n\r",inR);
        
        while(1)
        {
        if (filter_timer_go){
                filter_timer_go=false;
                FilteredSample();}
        }
}