#include "mbed.h"

InterruptIn button(p5);
DigitalOut led(LED1);
DigitalOut flash(LED4);

void flip() {
    led = !led; // toggles the led, when pressing a button connects ground to p5.
    }
    
    int main() {
        button.mode(PullUp); // with this command, no external pullup resistor needed
        button.rise(&flip);  // attach the function address to the rising edge (of p5)
        while(1) {           // wait around, interrupts will interrupt this!
            flash = !flash;  // this just turns LED4 on and off every quarter-second 
            wait(0.25);      // this is the instruction to wait for a quarter-second
    }
}
