#ifndef TOUCHCONTROLLER_H
#define TOUCHCONTROLLER_H

// Macros for calibration function
#define X_T1 t[0][0]
#define X_T2 t[1][0]
#define X_T3 t[2][0]

#define Y_T1 t[0][1]
#define Y_T2 t[1][1]
#define Y_T3 t[2][1]

#define X_D1 d[0][0]
#define X_D2 d[1][0]
#define X_D3 d[2][0]

#define Y_D1 d[0][1]
#define Y_D2 d[1][1]
#define Y_D3 d[2][1]

//Includes
#include "mbed.h"

class TouchController
{
public:
  TouchController(PinName ur, PinName lr,PinName s, PinName ul, PinName ll,  int num_of_samples = 5, int settle = 100);

  int TouchDetected();

  float RawX();
  float RawY();

  float GetX();
  float GetY();

  void Calibrate(float t[3][2], float d[3][2]);

  void SetSettleTime(int settle);

private:
  DigitalInOut _UR;
  DigitalInOut _LR;
  PinName _S;
  DigitalInOut _UL;
  DigitalInOut _LL;

  uint32_t _settle;

  static const char DETECT = 1;
  static const char X = 2;
  static const char Y = 3;

  float A;
  float B;
  float C;
  float D;
  float E;
  float F;

  int n_samples;

  void ConfigPins(char mode);
  float MeasureS();

};
#endif
