#include "TouchController.hpp"

TouchController::TouchController(PinName ur, PinName lr, PinName s, PinName ul, PinName ll, int num_of_samples, int settle) :
  _UR(ur),
  _LR(lr),
  _UL(ul),
  _LL(ll)
{
  _UR.output();
  _UR.mode(PullNone);

  _UL.output();
  _UL.mode(PullNone);

  _LR.output();
  _LR.mode(PullNone);

  _LL.output();
  _LL.mode(PullNone);

  _S = s;
  n_samples = num_of_samples;

  _settle = settle;

  A = 1660.540541f;
  B = 20.5005005f;
  C = -334.0556557f;
  D = 0.0f;
  E = 1517.037037f;
  F = -246.5185185;
}

int TouchController::TouchDetected()
{
  DigitalIn S(_S, PullUp);
  ConfigPins(DETECT);
  Thread::wait(_settle);

  return (S.read() == 1 ? 0 : 1);
}

float TouchController::RawX()
{
  ConfigPins(X);
  Thread::wait(_settle);

  return MeasureS();
}

float TouchController::RawY()
{
  ConfigPins(Y);
  Thread::wait(_settle);
  return MeasureS();
}

float TouchController::GetX()
{
  ConfigPins(X);
  Thread::wait(_settle);
  float x_t = MeasureS();

  ConfigPins(Y);
  Thread::wait(_settle);
  float y_t = MeasureS();

  return (A*x_t+B*y_t+C);
}

float TouchController::GetY()
{
  ConfigPins(X);
  Thread::wait(_settle);
  float x_t = MeasureS();

  ConfigPins(Y);
  Thread::wait(_settle);
  float y_t = MeasureS();

  return (D*x_t+E*y_t+F);
}

void TouchController::Calibrate(float t[3][2], float d[3][2])
{
  A = (X_D1*(Y_T2-Y_T3)+X_D2*(Y_T3-Y_T1)+X_D3*(Y_T1-Y_T2))/(X_T1*(Y_T2-Y_T3)+X_T2*(Y_T3-Y_T1)+X_T3*(Y_T1-Y_T2));
  B = (A*(X_T3-X_T2)+X_D2-X_D3)/(Y_T2-Y_T3);
  C = X_D3-A*X_T3-B*Y_T3;
  D = (Y_D1*(Y_T2-Y_T3)+Y_D2*(Y_T3-Y_T1)+Y_D3*(Y_T1-Y_T2))/(X_T1*(Y_T2-Y_T3)+X_T2*(Y_T3-Y_T1)+X_T3*(Y_T1-Y_T2));
  E = (D*(X_T3-X_T2)+Y_D2-Y_D3)/(Y_T2-Y_T3);
  F = Y_D3-D*X_T3-E*Y_T3;
}

void TouchController::ConfigPins(char mode)
{
  switch (mode)
  {
    case DETECT:
      _UR.write(0);
      _UL.write(0);
      _LR.write(0);
      _LL.write(0);
      break;
    case X:
      _UR.write(1);
      _UL.write(0);
      _LR.write(1);
      _LL.write(0);
      break;
    case Y:
      _UR.write(1);
      _UL.write(1);
      _LR.write(0);
      _LL.write(0);
      break;
  }
}

float TouchController::MeasureS()
{
  AnalogIn S(_S);

 float measured_val = 0.0f;

 for( int i = 0; i < n_samples; i++)
 {
   measured_val += S.read();
 }

 return ( measured_val/n_samples);
}

void TouchController::SetSettleTime(int settle)
{
  _settle = settle;
}
