#ifndef SERVOCONTROLLER_H
#define SERVOCONTROLLER_H

//Includes
#include "mbed.h"

/**
 * A Servo controller library
 *
 * @author CA Bezuidenhout
 * @section USAGE EXAMPLE
 */
class ServoController
{
public:
  /**
   * @param pwmPin : PWM pin of servo
   * @param ref : Reference angle in degress (default 90)
   */
  ServoController(PinName pwmPin, float ref = 90.0f);

  /**
   * @return The current angle of the servo
   */
  float GetAngle();

  void SetAbsolute(float angle);

private:
  PwmOut _servo;
  float _angle;
  float _ref;
  float DEG2PW;
  float ZEROPW;

  void SetServo();
};

#endif
