#include "ServoController.hpp"

ServoController::ServoController(PinName pwmPin, float ref) :
  _servo(pwmPin)
{
    DEG2PW = (500.0f/45.0f)/(1000000.0f);
    ZEROPW = 500.0f/(1000000.0f);
    _ref = ref;
    _angle = _ref;
    _servo.period_us(5000);
    SerServo();
}

void ServoController::SetServo()
{
  _angle = ( _angle < 0.0f ? 0.0f : _angle > 180.0f ? 180.0f : _angle );

  _servo.pulsewidth(ZEROPW+DEG2PW*_angle);
}

float ServoController::GetAngle()
{
  return _angle;
}

void ServoController::SetAbsolute(float angle)
{
  _angle = angle;
  SetServo();
}
