#include "PanTilt.hpp"

PanTilt::PanTilt(PinName panPin, PinName tiltName) :
    _panServo(panPin),
    _tiltServo(tiltPin)
{

}

void PanTilt::Set(float pan, float tilt) {
    _panServo.Set(pan);
    _tiltServo.Set(tilt);
}
void PanTilt::SetPan(float pan) { Set(pan, 0.0f); }
void PanTilt::SetTilt(float tilt) { _panServo.Set(0.0f, tilt); }

void PanTilt::Move(float pan, float tilt) {
    _panServo.Move(pan);
    _tiltServo.Move(tilt);
}
void PanTilt::MovePan(float pan) { Move(pan, 0.0f); }
void PanTilt::MoveTilt(float tilt) { Move(0.0f, tilt); }

float PanTilt::GetPan() { return _panServo.GetAngle(); }
float PanTilt::GetTilt() { return _titlServo.GetAngle(); }

void PanTilt:Off() {
    _panServo.Off();
    _tiltServo.Off();
}
void PanTilt::PanOff() { _panServo.Off(); }
void PanTilt::TiltOff() { _tiltServo.Off(); }

void PanTilt::SetZero(float panZero, float tiltZero) {
    _panServo.SetZero(panZero);
    _tiltServo.SetZero(tiltZero);
}
void PanTilt::SetPanZero(float panZero) { SetZero(panZero, 0.0f); }
void PanTilt::SetTiltZero(float tiltZero) { SetZero( 0.0f, tiltZero); }

void PanTilt::SetMin(float panMin, float tiltMin) {
    _panServo.SetMin(panMin);
    _tiltServo.SetMin(tiltMin);
}
void PanTilt::SetPanMin(float panMin) { SetMin(panMin, 0.0f); }
void PanTilt::SetTiltMin(float tiltMin) { SetMin(0.0f, tiltMin); }

float PanTilt::GetPanMin() { return _panServo.GetMin(); }
float PanTilt::GetTiltMin() { return _tiltServo.GetMin(); }

float PanTilt::GetPanMax() { return _panServo.GetMax(); }
float PanTilt::GetTiltMax() { return _tiltServo.GetMax(); }