#ifndef _PANTILT_
#define _PANTILT_

#include "mbed.h"

/**
 *  Library for a sevo controlled pan tilt
 *
 * @author CA Bezuidenhout
 */
class PanTilt {

public:
    /**
     * @param panPin : PWM pin of pan servo
     * @param tiltPin : PWM pin of tilt servo
     */
    PanTilt(PinName panPin, PinName tiltName);

    /**
     * Sets pan, tilt angles in degrees
     * @param pan : Pan angle in degrees
     * @param tilt : Tilt angle in degrees
     */
    void Set(float pan, float tilt);

    /**
     * Sets the pan angle in degrees
     * @param pan : Pan angle in degrees
     */
    void SetPan(float pan);

    /**
     * Sets tilt angle in degrees
     * @param tilt : Tilt angle in degrees
     */
    void SetTilt(float tilt);

    /**
     * Moves the pan, tilt with specified degrees relative to current position
     * @param pan : Relative pan angle in degrees
     * @param tilt : Relative tilt angle in degrees
     */
    void Move(float pan, float tilt);

    /**
     * Moves the pan with specified degrees relative to current position
     * @param pan : Relative pan angle in degrees
     */
    void MovePan(float pan, float tilt);

    /**
     * Moves the tilt with specified degrees relative to current position
     * @param tilt : Relative tilt angle in degrees
     */
    void MoveTilt(float pan, float tilt);

    float GetPan();
    float GetTilt();

    void Off();
    void PanOff();
    void TiltOff();

    void SetZero(float panZero, float tiltZero);
    void SetPanZero(float panZero);
    void SetTiltZero(float tiltZero);

    void SetMin(float panMin, float tiltMin);
    void SetPanMin(float panMin);
    void SetTiltMin(float tiltMin);

    float GetPanMin();
    float GetTiltMin();

    float GetPanMax();
    float GetTiltMax();

private:
    Servo _panServo;
    Servo _tiltServo;
};
#endif