#ifndef SCREEN_HPP
#define SCREEN_HPP

#include "ButtonGroup.hpp"
#include "Graph.hpp"
#include "ImageFromSD.hpp"
#include "NumericLabel.hpp"
#include "Trackpad.hpp"
#include "GuiBase.hpp"
#include "Numpad.hpp"
#include "IntNumpad.hpp"
#include "Canvas.hpp"

class Screen : public GuiBase
{
public:
  Screen();

  virtual void Draw() = 0;
  virtual void Process() = 0;

  void Clear();

  static const int MAIN_MENU_SCREEN = 1;
  static const int MAIN_SETTINGS_SCREEN = 2;
  static const int ZERO_PLATE_SCREEN = 3;
  static const int MANUAL_CONTROL_SCREEN = 4;
  static const int AUTOMATIC_CONTROL_SCREEN = 5;
  static const int AUTOMATIC_MORE_SCREEN = 6;
  static const int MANUAL_SETPOINT_SCREEN = 7;
  static const int AUTOMATIC_SETTINGS_SCREEN = 8;
  static const int CHANGE_P_SCREEN = 9;
  static const int CHANGE_I_SCREEN = 10;
  static const int CHANGE_D_SCREEN = 11;
  static const int CHANGE_TS_SCREEN = 12;
  static const int CALIBRATE_SCREEN = 13;
  static const int SQUARE_SCREEN = 14;

  static const int SCREEN_W = 480;
  static const int SCREEN_H = 272;

protected:
    int *_nextScreen;

};
#endif
