#include "ChangeValWholeScreen.hpp"

ChangeValWholeScreen::ChangeValWholeScreen(int *nextScreen, int prevScreen, float *valToChange, string title, bool negative, float min) :
  Screen(),
  _lbTitle( SCREEN_W/2, 0, title, Label::CENTER, Font24),
  _btBack( 0, SCREEN_H-30, 100, 30, "Back"),
  _btSave( SCREEN_W-100, SCREEN_H-30, 100, 30, "Save"),
  _btNeg( 110, SCREEN_H-100, SCREEN_W-220, 30, "-"),
  _btPos( 110, SCREEN_H-100, SCREEN_W-220, 30, "+"),
  _npValue( 0, 48, SCREEN_W, SCREEN_H-83),
  _nlbValue(SCREEN_W/2, 26, "%.0f", *valToChange, Label::CENTER, Font20)
{
  _nextScreen = nextScreen;
  _prevScreen = prevScreen;
  _value = valToChange;
  _min = min;
  _neg = negative;
  _negVal = false;
}

void ChangeValWholeScreen::Draw()
{
  Clear();
  _lbTitle.Draw();
  _btBack.Draw();
  _btSave.Draw();
  _npValue.Draw();
  _nlbValue.Draw();

  if( _neg )
  {
    _btNeg.Draw();
  }
}

void ChangeValWholeScreen::Process()
{
  if( _btBack.Touched() )
    *_nextScreen = _prevScreen;

  if( _btSave.Touched() )
  {
    *_value = _tempVal;
    *_nextScreen = _prevScreen;
  }

  if( _npValue.Touched() )
  {
    Update();
    Thread::wait(200);
  }


  if( _neg )
  {
    if( _btNeg.IsActive() )
    {
      if( _btNeg.Touched() )
      {
        _negVal = true;
        _btNeg.Inactivate();
        _btNeg.Erase();

        _btPos.Activate();
        _btPos.Draw();

        Update();
        Thread::wait(200);
      }
    }
    else if( _btPos.IsActive() )
    {
        if( _btPos.Touched() )
        {
          _negVal = false;
          _btPos.Inactivate();
          _btPos.Erase();

          _btNeg.Activate();
          _btNeg.Draw();

          Update();
          Thread::wait(200);
        }
    }
  }
}

void ChangeValWholeScreen::Update()
{
  _tempVal = _npValue.GetFloat();

  if( _negVal )
    _tempVal *= -1;

  if( _tempVal < _min)
    _tempVal = _min;

  _nlbValue.Draw("%.0f", _tempVal );
}
