#ifndef AUTOMATIC_SETTINGS_SCREEN_HPP
#define AUTOMATIC_SETTINGS_SCREEN_HPP

#include "Screen.hpp"

class AutomaticSettingsScreen : public Screen
{
public:
  AutomaticSettingsScreen(int *nextScreen, float *P, float *I, float *D, float *Ts);

  void Draw();
  void Process();

private:
  Label _lbTitle;
  Button _btBack;
  NumericLabel<float> _nlbP;
  Button _btP;
  NumericLabel<float> _nlbI;
  Button _btI;
  NumericLabel<float> _nlbD;
  Button _btD;
  NumericLabel<float> _nlbTs;
  Button _btTs;

  float *_P;
  float *_I;
  float *_D;
  float *_Ts;
};
#endif
