#include "AutomaticMoreScreen.hpp"

AutomaticMoreScreen::AutomaticMoreScreen(int *nextScreen) :
  Screen(),
  _lbTitle( SCREEN_W/2, 0, "More", Label::CENTER, Font24),
  _btBack(0,SCREEN_H-30,100,30,"Back"),
  _btManualSP(0, 27, SCREEN_W/2-5, SCREEN_H-35-27, "Manual Tracking",Font20),
  _btSquare(SCREEN_W/2+5,27, SCREEN_W/2-5, SCREEN_H-35-27, "4-Point Pattern",Font20)
{
  _nextScreen = nextScreen;
}

void AutomaticMoreScreen::Draw()
{
  Clear();
  _lbTitle.Draw();
  _btBack.Draw();
  _btManualSP.Draw();
  _btSquare.Draw();
}

void AutomaticMoreScreen::Process()
{
  if( _btBack.Touched() )
    *_nextScreen = AUTOMATIC_CONTROL_SCREEN;

  if( _btManualSP.Touched() )
  {
    *_nextScreen = MANUAL_SETPOINT_SCREEN;
  }

  if( _btSquare.Touched() )
  {
    *_nextScreen = SQUARE_SCREEN;
  }
}
