#include "ZeroPlateScreen.hpp"

ZeroPlateScreen::ZeroPlateScreen(int *nextScreen, float *zeroAlpha, float *zeroBeta, bool *saved) :
  Screen(),
  _lbTitle( SCREEN_W/2, 0, "Zero Plate", Label::CENTER, Font24),
  _btBack( 0, SCREEN_H-30, 100, 30, "Back"),
  _btSave( SCREEN_W-100, SCREEN_H-30, 100, 30, "Save"),
  _btAlphaUp( (SCREEN_W/2)-26, 28, 72, 72, "U"),
  _btAlphaDown( (SCREEN_W/2)-26, 182, 72, 72, "D"),
  _btBetaUp( (SCREEN_W/2)-103, 105, 72, 72, "L"),
  _btBetaDown( (SCREEN_W/2)+51, 105, 72, 72,"R") // TODO Add custom font
{
  _nextScreen = nextScreen;
  _zeroAlpha = zeroAlpha;
  _zeroBeta = zeroBeta;
  _saved = saved;
  *_zeroAlpha = 0;
  *_zeroBeta = 0;
}

void ZeroPlateScreen::Draw()
{
  Clear();
  _lbTitle.Draw();
  _btBack.Draw();
  _btSave.Draw();
  _btAlphaUp.Draw();
  _btAlphaDown.Draw();
  _btBetaUp.Draw();
  _btBetaDown.Draw();
}

void ZeroPlateScreen::Process()
{
  if( _btBack.Touched() )
    *_nextScreen = MAIN_SETTINGS_SCREEN;

  if( _btSave.Touched() )
    *_saved = true;

  if( _btAlphaUp.Touched() )
  {
    *_zeroAlpha += 1;
    Thread::wait(200);
    _btAlphaUp.Draw();
  }

  if( _btAlphaDown.Touched() )
  {
    *_zeroAlpha -= 1;
    Thread::wait(200);
    _btAlphaDown.Draw();
  }

  if( _btBetaUp.Touched() )
  {
    *_zeroBeta += 1;
    Thread::wait(200);
    _btBetaUp.Draw();
  }

  if( _btBetaDown.Touched() )
  {
    *_zeroBeta -= 1;
    Thread::wait(200);
    _btBetaDown.Draw();
  }
}
